/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.amulet.range;

import com.volmit.adapt.util.arcane.amulet.range.NumberRange;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class DoubleRange
extends NumberRange<Double, DoubleRange> {
    public DoubleRange(Double d, Double d2) {
        this(d, d2, 1.0);
    }

    public DoubleRange unaryMinus() {
        Double d = (Double)this.getLeftEndpoint();
        Double d2 = (Double)this.getRightEndpoint();
        if (this.isReversed()) {
            return new DoubleRange(d, d2, (Double)this.getStep(), true, true, false);
        }
        return new DoubleRange(d2, d, (Double)this.getStep(), true, true, true);
    }

    public DoubleRange(Double d, Double d2, double d3) {
        this(d, d2, d3, true, true, false);
    }

    public DoubleRange(Double d, Double d2, double d3, boolean bl, boolean bl2, boolean bl3) {
        super(d, d2, d3, bl, bl2, bl3);
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The step must be greater than 0: " + d3);
        }
    }

    @Override
    public Iterator<Double> iterateFromLeft() {
        return new ForwardIterator();
    }

    @Override
    public Iterator<Double> iterateFromRight() {
        return new ReverseIterator();
    }

    @Override
    public Double getFromLeft(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + n);
        }
        if (!this.isLeftClosed()) {
            ++n;
        }
        double d = (Double)this.getLeftEndpoint() + (Double)this.getStep() * (double)n;
        if (this.isRightClosed() ? d <= (Double)this.getRightEndpoint() : d < (Double)this.getRightEndpoint()) {
            return d;
        }
        return null;
    }

    @Override
    public Double getFromRight(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + n);
        }
        if (!this.isRightClosed()) {
            ++n;
        }
        double d = (Double)this.getRightEndpoint() - (Double)this.getStep() * (double)n;
        if (this.isLeftClosed() ? d >= (Double)this.getLeftEndpoint() : d > (Double)this.getLeftEndpoint()) {
            return d;
        }
        return null;
    }

    static {
        IBootstrap.dasBoot();
    }

    public class ForwardIterator
    implements Iterator<Double> {
        private double _csr;

        ForwardIterator() {
            this._csr = (Double)DoubleRange.this.getLeftEndpoint();
            if (!DoubleRange.this.isLeftClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this._csr < (Double)DoubleRange.this.getRightEndpoint() || DoubleRange.this.isRightClosed() && this._csr == (Double)DoubleRange.this.getRightEndpoint();
        }

        @Override
        public Double next() {
            if (this._csr > (Double)DoubleRange.this.getRightEndpoint() || !DoubleRange.this.isRightClosed() && this._csr == (Double)DoubleRange.this.getRightEndpoint()) {
                throw new NoSuchElementException();
            }
            double d = this._csr;
            this._csr += ((Double)DoubleRange.this.getStep()).doubleValue();
            return d;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ReverseIterator
    implements Iterator<Double> {
        private double _csr;

        ReverseIterator() {
            this._csr = (Double)DoubleRange.this.getRightEndpoint();
            if (!DoubleRange.this.isRightClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this._csr > (Double)DoubleRange.this.getLeftEndpoint() || DoubleRange.this.isLeftClosed() && this._csr == (Double)DoubleRange.this.getLeftEndpoint();
        }

        @Override
        public Double next() {
            if (this._csr < (Double)DoubleRange.this.getLeftEndpoint() || !DoubleRange.this.isLeftClosed() && this._csr == (Double)DoubleRange.this.getLeftEndpoint()) {
                throw new NoSuchElementException();
            }
            double d = this._csr;
            this._csr -= ((Double)DoubleRange.this.getStep()).doubleValue();
            return d;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

