/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.amulet.range;

import com.volmit.adapt.util.arcane.amulet.range.AbstractIntIterator;
import com.volmit.adapt.util.arcane.amulet.range.NumberRange;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IntegerRange
extends NumberRange<Integer, IntegerRange> {
    public IntegerRange(Integer n, Integer n2) {
        this(n, n2, 1);
    }

    public IntegerRange(Integer n, Integer n2, int n3) {
        this(n, n2, n3, true, true, false);
    }

    public IntegerRange(Integer n, Integer n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        super(n, n2, n3, bl, bl2, bl3);
        if (n3 <= 0) {
            throw new IllegalArgumentException("The step must be greater than 0: " + n3);
        }
    }

    public IntegerRange unaryMinus() {
        int n = (Integer)this.getLeftEndpoint();
        int n2 = (Integer)this.getRightEndpoint();
        if (this.isReversed()) {
            return new IntegerRange(n, n2, (Integer)this.getStep(), true, true, false);
        }
        return new IntegerRange(n2, n, (Integer)this.getStep(), true, true, true);
    }

    @Override
    public Iterator<Integer> iterateFromLeft() {
        return new ForwardIterator();
    }

    @Override
    public Iterator<Integer> iterateFromRight() {
        return new ReverseIterator();
    }

    @Override
    public Integer getFromLeft(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + n);
        }
        if (!this.isLeftClosed()) {
            ++n;
        }
        int n2 = (Integer)this.getLeftEndpoint() + (Integer)this.getStep() * n;
        if (this.isRightClosed() ? n2 <= (Integer)this.getRightEndpoint() : n2 < (Integer)this.getRightEndpoint()) {
            return n2;
        }
        return null;
    }

    @Override
    public Integer getFromRight(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + n);
        }
        if (!this.isRightClosed()) {
            ++n;
        }
        int n2 = (Integer)this.getRightEndpoint() - (Integer)this.getStep() * n;
        if (this.isLeftClosed() ? n2 >= (Integer)this.getLeftEndpoint() : n2 > (Integer)this.getLeftEndpoint()) {
            return n2;
        }
        return null;
    }

    static {
        IBootstrap.dasBoot();
    }

    public class ForwardIterator
    extends AbstractIntIterator {
        private int _csr;

        public ForwardIterator() {
            this._csr = (Integer)IntegerRange.this.getLeftEndpoint();
            if (!IntegerRange.this.isLeftClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this._csr < (Integer)IntegerRange.this.getRightEndpoint() || IntegerRange.this.isRightClosed() && this._csr == (Integer)IntegerRange.this.getRightEndpoint();
        }

        @Override
        public Integer next() {
            return this.nextInt();
        }

        @Override
        public int nextInt() {
            if (this._csr > (Integer)IntegerRange.this.getRightEndpoint() || !IntegerRange.this.isRightClosed() && this._csr == (Integer)IntegerRange.this.getRightEndpoint()) {
                throw new NoSuchElementException();
            }
            int n = this._csr;
            this._csr += ((Integer)IntegerRange.this.getStep()).intValue();
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ReverseIterator
    extends AbstractIntIterator {
        private int _csr;

        public ReverseIterator() {
            this._csr = (Integer)IntegerRange.this.getRightEndpoint();
            if (!IntegerRange.this.isRightClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this._csr > (Integer)IntegerRange.this.getLeftEndpoint() || IntegerRange.this.isLeftClosed() && this._csr == (Integer)IntegerRange.this.getLeftEndpoint();
        }

        @Override
        public Integer next() {
            return this.nextInt();
        }

        @Override
        public int nextInt() {
            if (this._csr < (Integer)IntegerRange.this.getLeftEndpoint() || !IntegerRange.this.isLeftClosed() && this._csr == (Integer)IntegerRange.this.getLeftEndpoint()) {
                throw new NoSuchElementException();
            }
            int n = this._csr;
            this._csr -= ((Integer)IntegerRange.this.getStep()).intValue();
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

