/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.amulet.range;

import com.volmit.adapt.util.arcane.amulet.range.AbstractIterableRange;
import com.volmit.adapt.util.arcane.amulet.range.Sequential;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SequentialRange<E extends Sequential<E, S, U>, S, U>
extends AbstractIterableRange<E, S, U, SequentialRange<E, S, U>> {
    public SequentialRange(E e, E e2, S s, U u, boolean bl, boolean bl2, boolean bl3) {
        super(e, e2, s, u, bl3 ? bl2 : bl, bl3 ? bl : bl2, bl3);
    }

    @Override
    public Iterator<E> iterateFromLeft() {
        return new SequentialIterator();
    }

    public SequentialRange<E, S, U> unaryMinus() {
        Sequential sequential = (Sequential)this.getLeftEndpoint();
        Sequential sequential2 = (Sequential)this.getRightEndpoint();
        if (this.isReversed()) {
            return new SequentialRange(sequential, sequential2, this.getStep(), this.getUnit(), true, true, false);
        }
        return new SequentialRange(sequential2, sequential, this.getStep(), this.getUnit(), true, true, true);
    }

    @Override
    public Iterator<E> iterateFromRight() {
        return new ReverseSequentialIterator();
    }

    @Override
    public E getFromLeft(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + n);
        }
        if (!this.isLeftClosed()) {
            ++n;
        }
        Object e = ((Sequential)this.getLeftEndpoint()).nextNthInSequence(this.getStep(), this.getUnit(), n);
        int n2 = e.compareTo((Sequential)((Sequential)this.getRightEndpoint()));
        if (this.isRightClosed() ? n2 <= 0 : n2 < 0) {
            return e;
        }
        return null;
    }

    @Override
    public E getFromRight(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + n);
        }
        if (!this.isRightClosed()) {
            ++n;
        }
        Object e = ((Sequential)this.getRightEndpoint()).previousNthInSequence(this.getStep(), this.getUnit(), n);
        int n2 = e.compareTo((Sequential)((Sequential)this.getLeftEndpoint()));
        if (this.isLeftClosed() ? n2 >= 0 : n2 > 0) {
            return e;
        }
        return null;
    }

    static {
        IBootstrap.dasBoot();
    }

    private class SequentialIterator
    implements Iterator<E> {
        private E _csr;

        public SequentialIterator() {
            this._csr = (Sequential)SequentialRange.this.getLeftEndpoint();
            if (!SequentialRange.this.isLeftClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            if (this._csr == null) {
                return false;
            }
            int n = this._csr.compareTo((Sequential)((Sequential)SequentialRange.this.getRightEndpoint()));
            return n < 0 || SequentialRange.this.isRightClosed() && n == 0;
        }

        @Override
        public E next() {
            int n = this._csr.compareTo((Sequential)((Sequential)SequentialRange.this.getRightEndpoint()));
            if (n > 0 || !SequentialRange.this.isRightClosed() && n == 0) {
                throw new NoSuchElementException();
            }
            Object e = this._csr;
            this._csr = this._csr.nextInSequence(SequentialRange.this.getStep(), SequentialRange.this.getUnit());
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ReverseSequentialIterator
    implements Iterator<E> {
        private E _csr;

        public ReverseSequentialIterator() {
            this._csr = (Sequential)SequentialRange.this.getRightEndpoint();
            if (!SequentialRange.this.isRightClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            if (this._csr == null) {
                return false;
            }
            int n = this._csr.compareTo((Sequential)((Sequential)SequentialRange.this.getLeftEndpoint()));
            return n > 0 || SequentialRange.this.isLeftClosed() && n == 0;
        }

        @Override
        public E next() {
            int n = this._csr.compareTo((Sequential)((Sequential)SequentialRange.this.getLeftEndpoint()));
            if (n < 0 || !SequentialRange.this.isLeftClosed() && n == 0) {
                throw new NoSuchElementException();
            }
            Object e = this._csr;
            this._csr = this._csr.previousInSequence(SequentialRange.this.getStep(), SequentialRange.this.getUnit());
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

