/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.model;

import com.volmit.adapt.util.arcane.curse.Curse;
import com.volmit.adapt.util.arcane.curse.model.CursedContext;
import com.volmit.adapt.util.arcane.curse.model.CursedExecutable;
import java.lang.reflect.Constructor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spoon.reflect.declaration.CtConstructor;

public class CursedConstructor
extends CursedExecutable {
    private final Constructor<?> constructor;

    public CursedConstructor(CursedContext cursedContext, Constructor<?> constructor) {
        super(cursedContext, constructor);
        this.constructor = constructor;
    }

    public CtConstructor<?> model() {
        return (CtConstructor)Curse.on(this.constructor.getDeclaringClass()).model().filterChildren(ctConstructor -> ctConstructor.getParameters().stream().map(ctParameter -> ctParameter.getType().getActualClass().getCanonicalName()).collect(Collectors.joining(", ")).equals(Stream.of(this.constructor.getParameterTypes()).map(Class::getCanonicalName).collect(Collectors.joining(", ")))).first();
    }

    public <T> T invoke(Object ... objectArray) {
        try {
            this.constructor.setAccessible(true);
            return (T)this.constructor.newInstance(objectArray);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

