/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.util.poet;

import com.volmit.adapt.util.arcane.curse.util.poet.ClassName;
import com.volmit.adapt.util.arcane.curse.util.poet.CodeBlock;
import com.volmit.adapt.util.arcane.curse.util.poet.CodeWriter;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeName;
import com.volmit.adapt.util.arcane.curse.util.poet.Util;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

public final class AnnotationSpec {
    public static final String VALUE = "value";
    public final TypeName type;
    public final Map<String, List<CodeBlock>> members;

    private AnnotationSpec(Builder builder) {
        this.type = builder.type;
        this.members = Util.immutableMultimap(builder.members);
    }

    void emit(CodeWriter codeWriter, boolean bl) {
        String string;
        String string2 = bl ? "" : "\n";
        String string3 = string = bl ? ", " : ",\n";
        if (this.members.isEmpty()) {
            codeWriter.emit("@$T", this.type);
        } else if (this.members.size() == 1 && this.members.containsKey(VALUE)) {
            codeWriter.emit("@$T(", this.type);
            this.emitAnnotationValues(codeWriter, string2, string, this.members.get(VALUE));
            codeWriter.emit(")");
        } else {
            codeWriter.emit("@$T(" + string2, this.type);
            codeWriter.indent(2);
            Iterator<Map.Entry<String, List<CodeBlock>>> iterator = this.members.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, List<CodeBlock>> entry = iterator.next();
                codeWriter.emit("$L = ", entry.getKey());
                this.emitAnnotationValues(codeWriter, string2, string, entry.getValue());
                if (!iterator.hasNext()) continue;
                codeWriter.emit(string);
            }
            codeWriter.unindent(2);
            codeWriter.emit(string2 + ")");
        }
    }

    private void emitAnnotationValues(CodeWriter codeWriter, String string, String string2, List<CodeBlock> list) {
        if (list.size() == 1) {
            codeWriter.indent(2);
            codeWriter.emit(list.get(0));
            codeWriter.unindent(2);
            return;
        }
        codeWriter.emit("{" + string);
        codeWriter.indent(2);
        boolean bl = true;
        for (CodeBlock codeBlock : list) {
            if (!bl) {
                codeWriter.emit(string2);
            }
            codeWriter.emit(codeBlock);
            bl = false;
        }
        codeWriter.unindent(2);
        codeWriter.emit(string + "}");
    }

    public static AnnotationSpec get(Annotation annotation) {
        return AnnotationSpec.get(annotation, false);
    }

    public static AnnotationSpec get(Annotation annotation, boolean bl) {
        Builder builder = AnnotationSpec.builder(annotation.annotationType());
        try {
            Method[] methodArray = annotation.annotationType().getDeclaredMethods();
            Arrays.sort(methodArray, Comparator.comparing(Method::getName));
            for (Method method : methodArray) {
                Object object = method.invoke((Object)annotation, new Object[0]);
                if (!bl && Objects.deepEquals(object, method.getDefaultValue())) continue;
                if (object.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(object); ++i) {
                        builder.addMemberForValue(method.getName(), Array.get(object, i));
                    }
                    continue;
                }
                if (object instanceof Annotation) {
                    builder.addMember(method.getName(), "$L", AnnotationSpec.get((Annotation)object));
                    continue;
                }
                builder.addMemberForValue(method.getName(), object);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Reflecting " + annotation + " failed!", exception);
        }
        return builder.build();
    }

    public static AnnotationSpec get(AnnotationMirror annotationMirror) {
        TypeElement typeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
        Builder builder = AnnotationSpec.builder(ClassName.get(typeElement));
        Visitor visitor = new Visitor(builder);
        for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
            String string = executableElement.getSimpleName().toString();
            AnnotationValue annotationValue = annotationMirror.getElementValues().get(executableElement);
            annotationValue.accept(visitor, string);
        }
        return builder.build();
    }

    public static Builder builder(ClassName className) {
        Util.checkNotNull(className, "type == null", new Object[0]);
        return new Builder(className);
    }

    public static Builder builder(Class<?> clazz) {
        return AnnotationSpec.builder(ClassName.get(clazz));
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.type);
        for (Map.Entry<String, List<CodeBlock>> entry : this.members.entrySet()) {
            builder.members.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return builder;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            CodeWriter codeWriter = new CodeWriter(stringBuilder);
            codeWriter.emit("$L", this);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    public static final class Builder {
        private final TypeName type;
        public final Map<String, List<CodeBlock>> members = new LinkedHashMap<String, List<CodeBlock>>();

        private Builder(TypeName typeName) {
            this.type = typeName;
        }

        public Builder addMember(String string, String string2, Object ... objectArray) {
            return this.addMember(string, CodeBlock.of(string2, objectArray));
        }

        public Builder addMember(String string2, CodeBlock codeBlock) {
            List list = this.members.computeIfAbsent(string2, string -> new ArrayList());
            list.add(codeBlock);
            return this;
        }

        Builder addMemberForValue(String string, Object object) {
            Util.checkNotNull(string, "memberName == null", new Object[0]);
            Util.checkNotNull(object, "value == null, constant non-null value expected for %s", string);
            Util.checkArgument(SourceVersion.isName(string), "not a valid name: %s", string);
            if (object instanceof Class) {
                return this.addMember(string, "$T.class", object);
            }
            if (object instanceof Enum) {
                return this.addMember(string, "$T.$L", object.getClass(), ((Enum)object).name());
            }
            if (object instanceof String) {
                return this.addMember(string, "$S", object);
            }
            if (object instanceof Float) {
                return this.addMember(string, "$Lf", object);
            }
            if (object instanceof Character) {
                return this.addMember(string, "'$L'", Util.characterLiteralWithoutSingleQuotes(((Character)object).charValue()));
            }
            return this.addMember(string, "$L", object);
        }

        public AnnotationSpec build() {
            for (String string : this.members.keySet()) {
                Util.checkNotNull(string, "name == null", new Object[0]);
                Util.checkArgument(SourceVersion.isName(string), "not a valid name: %s", string);
            }
            return new AnnotationSpec(this);
        }
    }

    private static class Visitor
    extends SimpleAnnotationValueVisitor8<Builder, String> {
        final Builder builder;

        Visitor(Builder builder) {
            super(builder);
            this.builder = builder;
        }

        @Override
        protected Builder defaultAction(Object object, String string) {
            return this.builder.addMemberForValue(string, object);
        }

        @Override
        public Builder visitAnnotation(AnnotationMirror annotationMirror, String string) {
            return this.builder.addMember(string, "$L", AnnotationSpec.get(annotationMirror));
        }

        @Override
        public Builder visitEnumConstant(VariableElement variableElement, String string) {
            return this.builder.addMember(string, "$T.$L", variableElement.asType(), variableElement.getSimpleName());
        }

        @Override
        public Builder visitType(TypeMirror typeMirror, String string) {
            return this.builder.addMember(string, "$T.class", typeMirror);
        }

        @Override
        public Builder visitArray(List<? extends AnnotationValue> list, String string) {
            for (AnnotationValue annotationValue : list) {
                annotationValue.accept(this, string);
            }
            return this.builder;
        }
    }
}

