/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.util.poet;

import com.volmit.adapt.util.arcane.curse.util.poet.AnnotationSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.ArrayTypeName;
import com.volmit.adapt.util.arcane.curse.util.poet.ClassName;
import com.volmit.adapt.util.arcane.curse.util.poet.CodeWriter;
import com.volmit.adapt.util.arcane.curse.util.poet.ParameterizedTypeName;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeVariableName;
import com.volmit.adapt.util.arcane.curse.util.poet.Util;
import com.volmit.adapt.util.arcane.curse.util.poet.WildcardTypeName;
import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;

public class TypeName {
    public static final TypeName VOID = new TypeName("void");
    public static final TypeName BOOLEAN = new TypeName("boolean");
    public static final TypeName BYTE = new TypeName("byte");
    public static final TypeName SHORT = new TypeName("short");
    public static final TypeName INT = new TypeName("int");
    public static final TypeName LONG = new TypeName("long");
    public static final TypeName CHAR = new TypeName("char");
    public static final TypeName FLOAT = new TypeName("float");
    public static final TypeName DOUBLE = new TypeName("double");
    public static final ClassName OBJECT = ClassName.get("java.lang", "Object", new String[0]);
    private static final ClassName BOXED_VOID = ClassName.get("java.lang", "Void", new String[0]);
    private static final ClassName BOXED_BOOLEAN = ClassName.get("java.lang", "Boolean", new String[0]);
    private static final ClassName BOXED_BYTE = ClassName.get("java.lang", "Byte", new String[0]);
    private static final ClassName BOXED_SHORT = ClassName.get("java.lang", "Short", new String[0]);
    private static final ClassName BOXED_INT = ClassName.get("java.lang", "Integer", new String[0]);
    private static final ClassName BOXED_LONG = ClassName.get("java.lang", "Long", new String[0]);
    private static final ClassName BOXED_CHAR = ClassName.get("java.lang", "Character", new String[0]);
    private static final ClassName BOXED_FLOAT = ClassName.get("java.lang", "Float", new String[0]);
    private static final ClassName BOXED_DOUBLE = ClassName.get("java.lang", "Double", new String[0]);
    private final String keyword;
    public final List<AnnotationSpec> annotations;
    private String cachedString;

    private TypeName(String string) {
        this(string, new ArrayList<AnnotationSpec>());
    }

    private TypeName(String string, List<AnnotationSpec> list) {
        this.keyword = string;
        this.annotations = Util.immutableList(list);
    }

    TypeName(List<AnnotationSpec> list) {
        this(null, list);
    }

    public final TypeName annotated(AnnotationSpec ... annotationSpecArray) {
        return this.annotated(Arrays.asList(annotationSpecArray));
    }

    public TypeName annotated(List<AnnotationSpec> list) {
        Util.checkNotNull(list, "annotations == null", new Object[0]);
        return new TypeName(this.keyword, this.concatAnnotations(list));
    }

    public TypeName withoutAnnotations() {
        return new TypeName(this.keyword);
    }

    protected final List<AnnotationSpec> concatAnnotations(List<AnnotationSpec> list) {
        ArrayList<AnnotationSpec> arrayList = new ArrayList<AnnotationSpec>(this.annotations);
        arrayList.addAll(list);
        return arrayList;
    }

    public boolean isAnnotated() {
        return !this.annotations.isEmpty();
    }

    public boolean isPrimitive() {
        return this.keyword != null && this != VOID;
    }

    public boolean isBoxedPrimitive() {
        return this.equals(BOXED_BOOLEAN) || this.equals(BOXED_BYTE) || this.equals(BOXED_SHORT) || this.equals(BOXED_INT) || this.equals(BOXED_LONG) || this.equals(BOXED_CHAR) || this.equals(BOXED_FLOAT) || this.equals(BOXED_DOUBLE);
    }

    public TypeName box() {
        if (this.keyword == null) {
            return this;
        }
        if (this == VOID) {
            return BOXED_VOID;
        }
        if (this == BOOLEAN) {
            return BOXED_BOOLEAN;
        }
        if (this == BYTE) {
            return BOXED_BYTE;
        }
        if (this == SHORT) {
            return BOXED_SHORT;
        }
        if (this == INT) {
            return BOXED_INT;
        }
        if (this == LONG) {
            return BOXED_LONG;
        }
        if (this == CHAR) {
            return BOXED_CHAR;
        }
        if (this == FLOAT) {
            return BOXED_FLOAT;
        }
        if (this == DOUBLE) {
            return BOXED_DOUBLE;
        }
        throw new AssertionError((Object)this.keyword);
    }

    public TypeName unbox() {
        if (this.keyword != null) {
            return this;
        }
        if (this.equals(BOXED_VOID)) {
            return VOID;
        }
        if (this.equals(BOXED_BOOLEAN)) {
            return BOOLEAN;
        }
        if (this.equals(BOXED_BYTE)) {
            return BYTE;
        }
        if (this.equals(BOXED_SHORT)) {
            return SHORT;
        }
        if (this.equals(BOXED_INT)) {
            return INT;
        }
        if (this.equals(BOXED_LONG)) {
            return LONG;
        }
        if (this.equals(BOXED_CHAR)) {
            return CHAR;
        }
        if (this.equals(BOXED_FLOAT)) {
            return FLOAT;
        }
        if (this.equals(BOXED_DOUBLE)) {
            return DOUBLE;
        }
        throw new UnsupportedOperationException("cannot unbox " + this);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final String toString() {
        String string = this.cachedString;
        if (string == null) {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                CodeWriter codeWriter = new CodeWriter(stringBuilder);
                this.emit(codeWriter);
                this.cachedString = string = stringBuilder.toString();
            }
            catch (IOException iOException) {
                throw new AssertionError();
            }
        }
        return string;
    }

    CodeWriter emit(CodeWriter codeWriter) {
        if (this.keyword == null) {
            throw new AssertionError();
        }
        if (this.isAnnotated()) {
            codeWriter.emit("");
            this.emitAnnotations(codeWriter);
        }
        return codeWriter.emitAndIndent(this.keyword);
    }

    CodeWriter emitAnnotations(CodeWriter codeWriter) {
        for (AnnotationSpec annotationSpec : this.annotations) {
            annotationSpec.emit(codeWriter, true);
            codeWriter.emit(" ");
        }
        return codeWriter;
    }

    public static TypeName get(TypeMirror typeMirror) {
        return TypeName.get(typeMirror, new LinkedHashMap<TypeParameterElement, TypeVariableName>());
    }

    static TypeName get(TypeMirror typeMirror, final Map<TypeParameterElement, TypeVariableName> map) {
        return typeMirror.accept(new SimpleTypeVisitor8<TypeName, Void>(){

            @Override
            public TypeName visitPrimitive(PrimitiveType primitiveType, Void void_) {
                switch (primitiveType.getKind()) {
                    case BOOLEAN: {
                        return BOOLEAN;
                    }
                    case BYTE: {
                        return BYTE;
                    }
                    case SHORT: {
                        return SHORT;
                    }
                    case INT: {
                        return INT;
                    }
                    case LONG: {
                        return LONG;
                    }
                    case CHAR: {
                        return CHAR;
                    }
                    case FLOAT: {
                        return FLOAT;
                    }
                    case DOUBLE: {
                        return DOUBLE;
                    }
                }
                throw new AssertionError();
            }

            @Override
            public TypeName visitDeclared(DeclaredType declaredType, Void void_) {
                TypeName typeName;
                ClassName className = ClassName.get((TypeElement)declaredType.asElement());
                TypeMirror typeMirror = declaredType.getEnclosingType();
                TypeName typeName2 = typeName = typeMirror.getKind() != TypeKind.NONE && !declaredType.asElement().getModifiers().contains((Object)Modifier.STATIC) ? typeMirror.accept(this, null) : null;
                if (declaredType.getTypeArguments().isEmpty() && !(typeName instanceof ParameterizedTypeName)) {
                    return className;
                }
                ArrayList<TypeName> arrayList = new ArrayList<TypeName>();
                for (TypeMirror typeMirror2 : declaredType.getTypeArguments()) {
                    arrayList.add(TypeName.get(typeMirror2, map));
                }
                return typeName instanceof ParameterizedTypeName ? ((ParameterizedTypeName)typeName).nestedClass(className.simpleName(), arrayList) : new ParameterizedTypeName(null, className, arrayList);
            }

            @Override
            public TypeName visitError(ErrorType errorType, Void void_) {
                return this.visitDeclared((DeclaredType)errorType, void_);
            }

            @Override
            public ArrayTypeName visitArray(ArrayType arrayType, Void void_) {
                return ArrayTypeName.get(arrayType, (Map<TypeParameterElement, TypeVariableName>)map);
            }

            @Override
            public TypeName visitTypeVariable(javax.lang.model.type.TypeVariable typeVariable, Void void_) {
                return TypeVariableName.get(typeVariable, (Map<TypeParameterElement, TypeVariableName>)map);
            }

            @Override
            public TypeName visitWildcard(WildcardType wildcardType, Void void_) {
                return WildcardTypeName.get(wildcardType, (Map<TypeParameterElement, TypeVariableName>)map);
            }

            @Override
            public TypeName visitNoType(NoType noType, Void void_) {
                if (noType.getKind() == TypeKind.VOID) {
                    return VOID;
                }
                return (TypeName)super.visitUnknown(noType, void_);
            }

            @Override
            protected TypeName defaultAction(TypeMirror typeMirror, Void void_) {
                throw new IllegalArgumentException("Unexpected type mirror: " + typeMirror);
            }
        }, null);
    }

    public static TypeName get(Type type) {
        return TypeName.get(type, new LinkedHashMap<Type, TypeVariableName>());
    }

    static TypeName get(Type type, Map<Type, TypeVariableName> map) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (type == Void.TYPE) {
                return VOID;
            }
            if (type == Boolean.TYPE) {
                return BOOLEAN;
            }
            if (type == Byte.TYPE) {
                return BYTE;
            }
            if (type == Short.TYPE) {
                return SHORT;
            }
            if (type == Integer.TYPE) {
                return INT;
            }
            if (type == Long.TYPE) {
                return LONG;
            }
            if (type == Character.TYPE) {
                return CHAR;
            }
            if (type == Float.TYPE) {
                return FLOAT;
            }
            if (type == Double.TYPE) {
                return DOUBLE;
            }
            if (clazz.isArray()) {
                return ArrayTypeName.of(TypeName.get(clazz.getComponentType(), map));
            }
            return ClassName.get(clazz);
        }
        if (type instanceof ParameterizedType) {
            return ParameterizedTypeName.get((ParameterizedType)type, map);
        }
        if (type instanceof java.lang.reflect.WildcardType) {
            return WildcardTypeName.get((java.lang.reflect.WildcardType)type, map);
        }
        if (type instanceof TypeVariable) {
            return TypeVariableName.get((TypeVariable)type, map);
        }
        if (type instanceof GenericArrayType) {
            return ArrayTypeName.get((GenericArrayType)type, map);
        }
        throw new IllegalArgumentException("unexpected type: " + type);
    }

    static List<TypeName> list(Type[] typeArray) {
        return TypeName.list(typeArray, new LinkedHashMap<Type, TypeVariableName>());
    }

    static List<TypeName> list(Type[] typeArray, Map<Type, TypeVariableName> map) {
        ArrayList<TypeName> arrayList = new ArrayList<TypeName>(typeArray.length);
        for (Type type : typeArray) {
            arrayList.add(TypeName.get(type, map));
        }
        return arrayList;
    }

    static TypeName arrayComponent(TypeName typeName) {
        return typeName instanceof ArrayTypeName ? ((ArrayTypeName)typeName).componentType : null;
    }

    static ArrayTypeName asArray(TypeName typeName) {
        return typeName instanceof ArrayTypeName ? (ArrayTypeName)typeName : null;
    }
}

