/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.curse.util.poet;

import com.volmit.adapt.util.arcane.curse.util.poet.AnnotationSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.ClassName;
import com.volmit.adapt.util.arcane.curse.util.poet.CodeBlock;
import com.volmit.adapt.util.arcane.curse.util.poet.CodeWriter;
import com.volmit.adapt.util.arcane.curse.util.poet.FieldSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.MethodSpec;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeName;
import com.volmit.adapt.util.arcane.curse.util.poet.TypeVariableName;
import com.volmit.adapt.util.arcane.curse.util.poet.Util;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public final class TypeSpec {
    public final Kind kind;
    public final String name;
    public final CodeBlock anonymousTypeArguments;
    public final CodeBlock javadoc;
    public final List<AnnotationSpec> annotations;
    public final Set<Modifier> modifiers;
    public final List<TypeVariableName> typeVariables;
    public final TypeName superclass;
    public final List<TypeName> superinterfaces;
    public final Map<String, TypeSpec> enumConstants;
    public final List<FieldSpec> fieldSpecs;
    public final CodeBlock staticBlock;
    public final CodeBlock initializerBlock;
    public final List<MethodSpec> methodSpecs;
    public final List<TypeSpec> typeSpecs;
    final Set<String> nestedTypesSimpleNames;
    public final List<Element> originatingElements;
    public final Set<String> alwaysQualifiedNames;

    private TypeSpec(Builder builder) {
        this.kind = builder.kind;
        this.name = builder.name;
        this.anonymousTypeArguments = builder.anonymousTypeArguments;
        this.javadoc = builder.javadoc.build();
        this.annotations = Util.immutableList(builder.annotations);
        this.modifiers = Util.immutableSet(builder.modifiers);
        this.typeVariables = Util.immutableList(builder.typeVariables);
        this.superclass = builder.superclass;
        this.superinterfaces = Util.immutableList(builder.superinterfaces);
        this.enumConstants = Util.immutableMap(builder.enumConstants);
        this.fieldSpecs = Util.immutableList(builder.fieldSpecs);
        this.staticBlock = builder.staticBlock.build();
        this.initializerBlock = builder.initializerBlock.build();
        this.methodSpecs = Util.immutableList(builder.methodSpecs);
        this.typeSpecs = Util.immutableList(builder.typeSpecs);
        this.alwaysQualifiedNames = Util.immutableSet(builder.alwaysQualifiedNames);
        this.nestedTypesSimpleNames = new HashSet<String>(builder.typeSpecs.size());
        ArrayList<Element> arrayList = new ArrayList<Element>();
        arrayList.addAll(builder.originatingElements);
        for (TypeSpec typeSpec : builder.typeSpecs) {
            this.nestedTypesSimpleNames.add(typeSpec.name);
            arrayList.addAll(typeSpec.originatingElements);
        }
        this.originatingElements = Util.immutableList(arrayList);
    }

    private TypeSpec(TypeSpec typeSpec) {
        assert (typeSpec.anonymousTypeArguments == null);
        this.kind = typeSpec.kind;
        this.name = typeSpec.name;
        this.anonymousTypeArguments = null;
        this.javadoc = typeSpec.javadoc;
        this.annotations = Collections.emptyList();
        this.modifiers = Collections.emptySet();
        this.typeVariables = Collections.emptyList();
        this.superclass = null;
        this.superinterfaces = Collections.emptyList();
        this.enumConstants = Collections.emptyMap();
        this.fieldSpecs = Collections.emptyList();
        this.staticBlock = typeSpec.staticBlock;
        this.initializerBlock = typeSpec.initializerBlock;
        this.methodSpecs = Collections.emptyList();
        this.typeSpecs = Collections.emptyList();
        this.originatingElements = Collections.emptyList();
        this.nestedTypesSimpleNames = Collections.emptySet();
        this.alwaysQualifiedNames = Collections.emptySet();
    }

    public boolean hasModifier(Modifier modifier) {
        return this.modifiers.contains((Object)modifier);
    }

    public static Builder classBuilder(String string) {
        return new Builder(Kind.CLASS, Util.checkNotNull(string, "name == null", new Object[0]), null);
    }

    public static Builder classBuilder(ClassName className) {
        return TypeSpec.classBuilder(Util.checkNotNull(className, "className == null", new Object[0]).simpleName());
    }

    public static Builder interfaceBuilder(String string) {
        return new Builder(Kind.INTERFACE, Util.checkNotNull(string, "name == null", new Object[0]), null);
    }

    public static Builder interfaceBuilder(ClassName className) {
        return TypeSpec.interfaceBuilder(Util.checkNotNull(className, "className == null", new Object[0]).simpleName());
    }

    public static Builder enumBuilder(String string) {
        return new Builder(Kind.ENUM, Util.checkNotNull(string, "name == null", new Object[0]), null);
    }

    public static Builder enumBuilder(ClassName className) {
        return TypeSpec.enumBuilder(Util.checkNotNull(className, "className == null", new Object[0]).simpleName());
    }

    public static Builder anonymousClassBuilder(String string, Object ... objectArray) {
        return TypeSpec.anonymousClassBuilder(CodeBlock.of(string, objectArray));
    }

    public static Builder anonymousClassBuilder(CodeBlock codeBlock) {
        return new Builder(Kind.CLASS, null, codeBlock);
    }

    public static Builder annotationBuilder(String string) {
        return new Builder(Kind.ANNOTATION, Util.checkNotNull(string, "name == null", new Object[0]), null);
    }

    public static Builder annotationBuilder(ClassName className) {
        return TypeSpec.annotationBuilder(Util.checkNotNull(className, "className == null", new Object[0]).simpleName());
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.kind, this.name, this.anonymousTypeArguments);
        builder.javadoc.add(this.javadoc);
        builder.annotations.addAll(this.annotations);
        builder.modifiers.addAll(this.modifiers);
        builder.typeVariables.addAll(this.typeVariables);
        builder.superclass = this.superclass;
        builder.superinterfaces.addAll(this.superinterfaces);
        builder.enumConstants.putAll(this.enumConstants);
        builder.fieldSpecs.addAll(this.fieldSpecs);
        builder.methodSpecs.addAll(this.methodSpecs);
        builder.typeSpecs.addAll(this.typeSpecs);
        builder.initializerBlock.add(this.initializerBlock);
        builder.staticBlock.add(this.staticBlock);
        builder.originatingElements.addAll(this.originatingElements);
        builder.alwaysQualifiedNames.addAll(this.alwaysQualifiedNames);
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emit(CodeWriter codeWriter, String string, Set<Modifier> set) {
        int n = codeWriter.statementLine;
        codeWriter.statementLine = -1;
        try {
            if (string != null) {
                codeWriter.emitJavadoc(this.javadoc);
                codeWriter.emitAnnotations(this.annotations, false);
                codeWriter.emit("$L", string);
                if (!this.anonymousTypeArguments.formatParts.isEmpty()) {
                    codeWriter.emit("(");
                    codeWriter.emit(this.anonymousTypeArguments);
                    codeWriter.emit(")");
                }
                if (this.fieldSpecs.isEmpty() && this.methodSpecs.isEmpty() && this.typeSpecs.isEmpty()) {
                    return;
                }
                codeWriter.emit(" {\n");
            } else if (this.anonymousTypeArguments != null) {
                var5_5 = !this.superinterfaces.isEmpty() ? this.superinterfaces.get(0) : this.superclass;
                codeWriter.emit("new $T(", var5_5);
                codeWriter.emit(this.anonymousTypeArguments);
                codeWriter.emit(") {\n");
            } else {
                boolean bl;
                List<Object> list;
                codeWriter.pushType(new TypeSpec(this));
                codeWriter.emitJavadoc(this.javadoc);
                codeWriter.emitAnnotations(this.annotations, false);
                codeWriter.emitModifiers(this.modifiers, Util.union(set, this.kind.asMemberModifiers));
                if (this.kind == Kind.ANNOTATION) {
                    codeWriter.emit("$L $L", "@interface", this.name);
                } else {
                    codeWriter.emit("$L $L", this.kind.name().toLowerCase(Locale.US), this.name);
                }
                codeWriter.emitTypeVariables(this.typeVariables);
                if (this.kind == Kind.INTERFACE) {
                    var5_5 = this.superinterfaces;
                    list = Collections.emptyList();
                } else {
                    var5_5 = this.superclass.equals(ClassName.OBJECT) ? Collections.emptyList() : Collections.singletonList(this.superclass);
                    list = this.superinterfaces;
                }
                if (!var5_5.isEmpty()) {
                    codeWriter.emit(" extends");
                    bl = true;
                    for (TypeName typeName : var5_5) {
                        if (!bl) {
                            codeWriter.emit(",");
                        }
                        codeWriter.emit(" $T", typeName);
                        bl = false;
                    }
                }
                if (!list.isEmpty()) {
                    codeWriter.emit(" implements");
                    bl = true;
                    for (TypeName typeName : list) {
                        if (!bl) {
                            codeWriter.emit(",");
                        }
                        codeWriter.emit(" $T", typeName);
                        bl = false;
                    }
                }
                codeWriter.popType();
                codeWriter.emit(" {\n");
            }
            codeWriter.pushType(this);
            codeWriter.indent();
            boolean bl = true;
            boolean bl2 = this.kind == Kind.ENUM && (!this.fieldSpecs.isEmpty() || !this.methodSpecs.isEmpty() || !this.typeSpecs.isEmpty());
            Iterator<Object> iterator = this.enumConstants.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, TypeSpec> entry = iterator.next();
                if (!bl) {
                    codeWriter.emit("\n");
                }
                entry.getValue().emit(codeWriter, entry.getKey(), Collections.emptySet());
                bl = false;
                if (iterator.hasNext()) {
                    codeWriter.emit(",\n");
                    continue;
                }
                if (bl2) continue;
                codeWriter.emit("\n");
            }
            if (bl2) {
                codeWriter.emit(";\n");
            }
            for (FieldSpec fieldSpec : this.fieldSpecs) {
                if (!fieldSpec.hasModifier(Modifier.STATIC)) continue;
                if (!bl) {
                    codeWriter.emit("\n");
                }
                fieldSpec.emit(codeWriter, this.kind.implicitFieldModifiers);
                bl = false;
            }
            if (!this.staticBlock.isEmpty()) {
                if (!bl) {
                    codeWriter.emit("\n");
                }
                codeWriter.emit(this.staticBlock);
                bl = false;
            }
            for (FieldSpec fieldSpec : this.fieldSpecs) {
                if (fieldSpec.hasModifier(Modifier.STATIC)) continue;
                if (!bl) {
                    codeWriter.emit("\n");
                }
                fieldSpec.emit(codeWriter, this.kind.implicitFieldModifiers);
                bl = false;
            }
            if (!this.initializerBlock.isEmpty()) {
                if (!bl) {
                    codeWriter.emit("\n");
                }
                codeWriter.emit(this.initializerBlock);
                bl = false;
            }
            for (MethodSpec methodSpec : this.methodSpecs) {
                if (!methodSpec.isConstructor()) continue;
                if (!bl) {
                    codeWriter.emit("\n");
                }
                methodSpec.emit(codeWriter, this.name, this.kind.implicitMethodModifiers);
                bl = false;
            }
            for (MethodSpec methodSpec : this.methodSpecs) {
                if (methodSpec.isConstructor()) continue;
                if (!bl) {
                    codeWriter.emit("\n");
                }
                methodSpec.emit(codeWriter, this.name, this.kind.implicitMethodModifiers);
                bl = false;
            }
            for (TypeSpec typeSpec : this.typeSpecs) {
                if (!bl) {
                    codeWriter.emit("\n");
                }
                typeSpec.emit(codeWriter, null, this.kind.implicitTypeModifiers);
                bl = false;
            }
            codeWriter.unindent();
            codeWriter.popType();
            codeWriter.popTypeVariables(this.typeVariables);
            codeWriter.emit("}");
            if (string == null && this.anonymousTypeArguments == null) {
                codeWriter.emit("\n");
            }
        }
        finally {
            codeWriter.statementLine = n;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            CodeWriter codeWriter = new CodeWriter(stringBuilder);
            this.emit(codeWriter, null, Collections.emptySet());
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    public static final class Builder {
        private final Kind kind;
        private final String name;
        private final CodeBlock anonymousTypeArguments;
        private final CodeBlock.Builder javadoc = CodeBlock.builder();
        private TypeName superclass = ClassName.OBJECT;
        private final CodeBlock.Builder staticBlock = CodeBlock.builder();
        private final CodeBlock.Builder initializerBlock = CodeBlock.builder();
        public final Map<String, TypeSpec> enumConstants = new LinkedHashMap<String, TypeSpec>();
        public final List<AnnotationSpec> annotations = new ArrayList<AnnotationSpec>();
        public final List<Modifier> modifiers = new ArrayList<Modifier>();
        public final List<TypeVariableName> typeVariables = new ArrayList<TypeVariableName>();
        public final List<TypeName> superinterfaces = new ArrayList<TypeName>();
        public final List<FieldSpec> fieldSpecs = new ArrayList<FieldSpec>();
        public final List<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        public final List<TypeSpec> typeSpecs = new ArrayList<TypeSpec>();
        public final List<Element> originatingElements = new ArrayList<Element>();
        public final Set<String> alwaysQualifiedNames = new LinkedHashSet<String>();

        private Builder(Kind kind, String string, CodeBlock codeBlock) {
            Util.checkArgument(string == null || SourceVersion.isName(string), "not a valid name: %s", string);
            this.kind = kind;
            this.name = string;
            this.anonymousTypeArguments = codeBlock;
        }

        public Builder addJavadoc(String string, Object ... objectArray) {
            this.javadoc.add(string, objectArray);
            return this;
        }

        public Builder addJavadoc(CodeBlock codeBlock) {
            this.javadoc.add(codeBlock);
            return this;
        }

        public Builder addAnnotations(Iterable<AnnotationSpec> iterable) {
            Util.checkArgument(iterable != null, "annotationSpecs == null", new Object[0]);
            for (AnnotationSpec annotationSpec : iterable) {
                this.annotations.add(annotationSpec);
            }
            return this;
        }

        public Builder addAnnotation(AnnotationSpec annotationSpec) {
            Util.checkNotNull(annotationSpec, "annotationSpec == null", new Object[0]);
            this.annotations.add(annotationSpec);
            return this;
        }

        public Builder addAnnotation(ClassName className) {
            return this.addAnnotation(AnnotationSpec.builder(className).build());
        }

        public Builder addAnnotation(Class<?> clazz) {
            return this.addAnnotation(ClassName.get(clazz));
        }

        public Builder addModifiers(Modifier ... modifierArray) {
            Collections.addAll(this.modifiers, modifierArray);
            return this;
        }

        public Builder addTypeVariables(Iterable<TypeVariableName> iterable) {
            Util.checkArgument(iterable != null, "typeVariables == null", new Object[0]);
            for (TypeVariableName typeVariableName : iterable) {
                this.typeVariables.add(typeVariableName);
            }
            return this;
        }

        public Builder addTypeVariable(TypeVariableName typeVariableName) {
            this.typeVariables.add(typeVariableName);
            return this;
        }

        public Builder superclass(TypeName typeName) {
            Util.checkState(this.kind == Kind.CLASS, "only classes have super classes, not " + this.kind, new Object[0]);
            Util.checkState(this.superclass == ClassName.OBJECT, "superclass already set to " + this.superclass, new Object[0]);
            Util.checkArgument(!typeName.isPrimitive(), "superclass may not be a primitive", new Object[0]);
            this.superclass = typeName;
            return this;
        }

        public Builder superclass(Type type) {
            return this.superclass(type, true);
        }

        public Builder superclass(Type type, boolean bl) {
            Class<?> clazz;
            this.superclass(TypeName.get(type));
            if (bl && (clazz = this.getRawType(type)) != null) {
                this.avoidClashesWithNestedClasses(clazz);
            }
            return this;
        }

        public Builder superclass(TypeMirror typeMirror) {
            return this.superclass(typeMirror, true);
        }

        public Builder superclass(TypeMirror typeMirror, boolean bl) {
            this.superclass(TypeName.get(typeMirror));
            if (bl && typeMirror instanceof DeclaredType) {
                TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                this.avoidClashesWithNestedClasses(typeElement);
            }
            return this;
        }

        public Builder addSuperinterfaces(Iterable<? extends TypeName> iterable) {
            Util.checkArgument(iterable != null, "superinterfaces == null", new Object[0]);
            for (TypeName typeName : iterable) {
                this.addSuperinterface(typeName);
            }
            return this;
        }

        public Builder addSuperinterface(TypeName typeName) {
            Util.checkArgument(typeName != null, "superinterface == null", new Object[0]);
            this.superinterfaces.add(typeName);
            return this;
        }

        public Builder addSuperinterface(Type type) {
            return this.addSuperinterface(type, true);
        }

        public Builder addSuperinterface(Type type, boolean bl) {
            Class<?> clazz;
            this.addSuperinterface(TypeName.get(type));
            if (bl && (clazz = this.getRawType(type)) != null) {
                this.avoidClashesWithNestedClasses(clazz);
            }
            return this;
        }

        private Class<?> getRawType(Type type) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return this.getRawType(((ParameterizedType)type).getRawType());
            }
            return null;
        }

        public Builder addSuperinterface(TypeMirror typeMirror) {
            return this.addSuperinterface(typeMirror, true);
        }

        public Builder addSuperinterface(TypeMirror typeMirror, boolean bl) {
            this.addSuperinterface(TypeName.get(typeMirror));
            if (bl && typeMirror instanceof DeclaredType) {
                TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                this.avoidClashesWithNestedClasses(typeElement);
            }
            return this;
        }

        public Builder addEnumConstant(String string) {
            return this.addEnumConstant(string, TypeSpec.anonymousClassBuilder("", new Object[0]).build());
        }

        public Builder addEnumConstant(String string, TypeSpec typeSpec) {
            this.enumConstants.put(string, typeSpec);
            return this;
        }

        public Builder addFields(Iterable<FieldSpec> iterable) {
            Util.checkArgument(iterable != null, "fieldSpecs == null", new Object[0]);
            for (FieldSpec fieldSpec : iterable) {
                this.addField(fieldSpec);
            }
            return this;
        }

        public Builder addField(FieldSpec fieldSpec) {
            this.fieldSpecs.add(fieldSpec);
            return this;
        }

        public Builder addField(TypeName typeName, String string, Modifier ... modifierArray) {
            return this.addField(FieldSpec.builder(typeName, string, modifierArray).build());
        }

        public Builder addField(Type type, String string, Modifier ... modifierArray) {
            return this.addField(TypeName.get(type), string, modifierArray);
        }

        public Builder addStaticBlock(CodeBlock codeBlock) {
            this.staticBlock.beginControlFlow("static", new Object[0]).add(codeBlock).endControlFlow();
            return this;
        }

        public Builder addInitializerBlock(CodeBlock codeBlock) {
            if (this.kind != Kind.CLASS && this.kind != Kind.ENUM) {
                throw new UnsupportedOperationException(this.kind + " can't have initializer blocks");
            }
            this.initializerBlock.add("{\n", new Object[0]).indent().add(codeBlock).unindent().add("}\n", new Object[0]);
            return this;
        }

        public Builder addMethods(Iterable<MethodSpec> iterable) {
            Util.checkArgument(iterable != null, "methodSpecs == null", new Object[0]);
            for (MethodSpec methodSpec : iterable) {
                this.addMethod(methodSpec);
            }
            return this;
        }

        public Builder addMethod(MethodSpec methodSpec) {
            this.methodSpecs.add(methodSpec);
            return this;
        }

        public Builder addTypes(Iterable<TypeSpec> iterable) {
            Util.checkArgument(iterable != null, "typeSpecs == null", new Object[0]);
            for (TypeSpec typeSpec : iterable) {
                this.addType(typeSpec);
            }
            return this;
        }

        public Builder addType(TypeSpec typeSpec) {
            this.typeSpecs.add(typeSpec);
            return this;
        }

        public Builder addOriginatingElement(Element element) {
            this.originatingElements.add(element);
            return this;
        }

        public Builder alwaysQualify(String ... stringArray) {
            Util.checkArgument(stringArray != null, "simpleNames == null", new Object[0]);
            for (String string : stringArray) {
                Util.checkArgument(string != null, "null entry in simpleNames array: %s", Arrays.toString(stringArray));
                this.alwaysQualifiedNames.add(string);
            }
            return this;
        }

        public Builder avoidClashesWithNestedClasses(TypeElement typeElement) {
            Util.checkArgument(typeElement != null, "typeElement == null", new Object[0]);
            for (TypeElement object : ElementFilter.typesIn(typeElement.getEnclosedElements())) {
                this.alwaysQualify(object.getSimpleName().toString());
            }
            TypeMirror typeMirror = typeElement.getSuperclass();
            if (!(typeMirror instanceof NoType) && typeMirror instanceof DeclaredType) {
                TypeElement typeElement2 = (TypeElement)((DeclaredType)typeMirror).asElement();
                this.avoidClashesWithNestedClasses(typeElement2);
            }
            for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
                if (!(typeMirror2 instanceof DeclaredType)) continue;
                TypeElement typeElement3 = (TypeElement)((DeclaredType)typeMirror2).asElement();
                this.avoidClashesWithNestedClasses(typeElement3);
            }
            return this;
        }

        public Builder avoidClashesWithNestedClasses(Class<?> clazz) {
            Util.checkArgument(clazz != null, "clazz == null", new Object[0]);
            for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
                this.alwaysQualify(clazz2.getSimpleName());
            }
            Class<?> clazz3 = clazz.getSuperclass();
            if (clazz3 != null && !Object.class.equals(clazz3)) {
                this.avoidClashesWithNestedClasses(clazz3);
            }
            for (Class<?> clazz4 : clazz.getInterfaces()) {
                this.avoidClashesWithNestedClasses(clazz4);
            }
            return this;
        }

        public TypeSpec build() {
            for (AnnotationSpec object : this.annotations) {
                Util.checkNotNull(object, "annotationSpec == null", new Object[0]);
            }
            if (!this.modifiers.isEmpty()) {
                Util.checkState(this.anonymousTypeArguments == null, "forbidden on anonymous types.", new Object[0]);
                for (Modifier modifier : this.modifiers) {
                    Util.checkArgument(modifier != null, "modifiers contain null", new Object[0]);
                }
            }
            for (TypeName typeName : this.superinterfaces) {
                Util.checkArgument(typeName != null, "superinterfaces contains null", new Object[0]);
            }
            if (!this.typeVariables.isEmpty()) {
                Util.checkState(this.anonymousTypeArguments == null, "typevariables are forbidden on anonymous types.", new Object[0]);
                for (TypeVariableName typeVariableName : this.typeVariables) {
                    Util.checkArgument(typeVariableName != null, "typeVariables contain null", new Object[0]);
                }
            }
            for (Map.Entry entry : this.enumConstants.entrySet()) {
                Util.checkState(this.kind == Kind.ENUM, "%s is not enum", this.name);
                Util.checkArgument(((TypeSpec)entry.getValue()).anonymousTypeArguments != null, "enum constants must have anonymous type arguments", new Object[0]);
                Util.checkArgument(SourceVersion.isName(this.name), "not a valid enum constant: %s", this.name);
            }
            for (FieldSpec fieldSpec : this.fieldSpecs) {
                if (this.kind != Kind.INTERFACE && this.kind != Kind.ANNOTATION) continue;
                Util.requireExactlyOneOf(fieldSpec.modifiers, Modifier.PUBLIC, Modifier.PRIVATE);
                EnumSet<Modifier> enumSet = EnumSet.of(Modifier.STATIC, Modifier.FINAL);
                Util.checkState(fieldSpec.modifiers.containsAll(enumSet), "%s %s.%s requires modifiers %s", new Object[]{this.kind, this.name, fieldSpec.name, enumSet});
            }
            for (MethodSpec methodSpec : this.methodSpecs) {
                if (this.kind == Kind.INTERFACE) {
                    Util.requireExactlyOneOf(methodSpec.modifiers, Modifier.PUBLIC, Modifier.PRIVATE);
                    if (methodSpec.modifiers.contains((Object)Modifier.PRIVATE)) {
                        Util.checkState(!methodSpec.hasModifier(Modifier.DEFAULT), "%s %s.%s cannot be private and default", new Object[]{this.kind, this.name, methodSpec.name});
                        Util.checkState(!methodSpec.hasModifier(Modifier.ABSTRACT), "%s %s.%s cannot be private and abstract", new Object[]{this.kind, this.name, methodSpec.name});
                    } else {
                        Util.requireExactlyOneOf(methodSpec.modifiers, Modifier.ABSTRACT, Modifier.STATIC, Modifier.DEFAULT);
                    }
                } else if (this.kind == Kind.ANNOTATION) {
                    Util.checkState(methodSpec.modifiers.equals(this.kind.implicitMethodModifiers), "%s %s.%s requires modifiers %s", new Object[]{this.kind, this.name, methodSpec.name, this.kind.implicitMethodModifiers});
                }
                if (this.kind != Kind.ANNOTATION) {
                    Util.checkState(methodSpec.defaultValue == null, "%s %s.%s cannot have a default value", new Object[]{this.kind, this.name, methodSpec.name});
                }
                if (this.kind == Kind.INTERFACE) continue;
                Util.checkState(!methodSpec.hasModifier(Modifier.DEFAULT), "%s %s.%s cannot be default", new Object[]{this.kind, this.name, methodSpec.name});
            }
            for (TypeSpec typeSpec : this.typeSpecs) {
                Util.checkArgument(typeSpec.modifiers.containsAll(this.kind.implicitTypeModifiers), "%s %s.%s requires modifiers %s", new Object[]{this.kind, this.name, typeSpec.name, this.kind.implicitTypeModifiers});
            }
            boolean bl = this.modifiers.contains((Object)Modifier.ABSTRACT) || this.kind != Kind.CLASS;
            for (MethodSpec methodSpec : this.methodSpecs) {
                Util.checkArgument(bl || !methodSpec.hasModifier(Modifier.ABSTRACT), "non-abstract type %s cannot declare abstract method %s", this.name, methodSpec.name);
            }
            boolean bl2 = this.superclass.equals(ClassName.OBJECT);
            int n = (bl2 ? 0 : 1) + this.superinterfaces.size();
            Util.checkArgument(this.anonymousTypeArguments == null || n <= 1, "anonymous type has too many supertypes", new Object[0]);
            return new TypeSpec(this);
        }
    }

    public static enum Kind {
        CLASS(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet()),
        INTERFACE(Util.immutableSet(Arrays.asList(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL)), Util.immutableSet(Arrays.asList(Modifier.PUBLIC, Modifier.ABSTRACT)), Util.immutableSet(Arrays.asList(Modifier.PUBLIC, Modifier.STATIC)), Util.immutableSet(Collections.singletonList(Modifier.STATIC))),
        ENUM(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.singleton(Modifier.STATIC)),
        ANNOTATION(Util.immutableSet(Arrays.asList(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL)), Util.immutableSet(Arrays.asList(Modifier.PUBLIC, Modifier.ABSTRACT)), Util.immutableSet(Arrays.asList(Modifier.PUBLIC, Modifier.STATIC)), Util.immutableSet(Collections.singletonList(Modifier.STATIC)));

        private final Set<Modifier> implicitFieldModifiers;
        private final Set<Modifier> implicitMethodModifiers;
        private final Set<Modifier> implicitTypeModifiers;
        private final Set<Modifier> asMemberModifiers;

        private Kind(Set<Modifier> set, Set<Modifier> set2, Set<Modifier> set3, Set<Modifier> set4) {
            this.implicitFieldModifiers = set;
            this.implicitMethodModifiers = set2;
            this.implicitTypeModifiers = set3;
            this.asMemberModifiers = set4;
        }
    }
}

