/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.container;

import com.volmit.adapt.util.arcane.spatial.container.Palette;
import com.volmit.adapt.util.arcane.spatial.util.Consume;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class LinearPalette<T>
implements Palette<T> {
    private final AtomicReference<AtomicReferenceArray<T>> palette;
    private final AtomicInteger size = new AtomicInteger(0);

    public LinearPalette(int n) {
        this.palette = new AtomicReference(new AtomicReferenceArray(n));
        this.palette.get().set(this.size.getAndIncrement(), null);
    }

    @Override
    public T get(int n) {
        if (n < 0 || n >= this.size.get()) {
            return null;
        }
        return this.palette.get().get(n);
    }

    @Override
    public int add(T t) {
        int n = this.size.getAndIncrement();
        this.grow(n + 1);
        this.palette.get().set(n, t);
        return n;
    }

    private void grow(int n) {
        if (n > this.palette.get().length()) {
            AtomicReferenceArray<T> atomicReferenceArray = new AtomicReferenceArray<T>(n + this.size.get());
            for (int i = 0; i < this.palette.get().length(); ++i) {
                atomicReferenceArray.set(i, this.palette.get().get(i));
            }
            this.palette.set(atomicReferenceArray);
        }
    }

    @Override
    public int id(T t) {
        if (t == null) {
            return 0;
        }
        for (int i = 1; i < this.size() + 1; ++i) {
            if (!t.equals(this.palette.get().get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.size.get() - 1;
    }

    @Override
    public void iterate(Consume.Two<T, Integer> two) {
        for (int i = 1; i < this.size() + 1; ++i) {
            two.accept(this.palette.get().get(i), i);
        }
    }
}

