/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.hunk.storage;

import com.volmit.adapt.util.arcane.spatial.hunk.Hunk;
import com.volmit.adapt.util.arcane.spatial.hunk.storage.StorageHunk;
import java.util.Arrays;

public class SynchronizedArrayHunk<T>
extends StorageHunk<T>
implements Hunk<T> {
    private final T[] data;

    public SynchronizedArrayHunk(int n, int n2, int n3) {
        super(n, n2, n3);
        this.data = new Object[n * n2 * n3];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRaw(int n, int n2, int n3, T t) {
        T[] TArray = this.data;
        synchronized (this.data) {
            this.data[this.index((int)n, (int)n2, (int)n3)] = t;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getRaw(int n, int n2, int n3) {
        T[] TArray = this.data;
        synchronized (this.data) {
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.data[this.index(n, n2, n3)];
        }
    }

    private int index(int n, int n2, int n3) {
        return n3 * this.getWidth() * this.getHeight() + n2 * this.getWidth() + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill(T t) {
        T[] TArray = this.data;
        synchronized (this.data) {
            Arrays.fill(this.data, t);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public T[] getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "SynchronizedArrayHunk(data=" + Arrays.deepToString(this.getData()) + ")";
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SynchronizedArrayHunk)) {
            return false;
        }
        SynchronizedArrayHunk synchronizedArrayHunk = (SynchronizedArrayHunk)object;
        if (!synchronizedArrayHunk.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getData(), synchronizedArrayHunk.getData());
    }

    @Override
    protected boolean canEqual(Object object) {
        return object instanceof SynchronizedArrayHunk;
    }

    @Override
    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + Arrays.deepHashCode(this.getData());
        return n2;
    }
}

