/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.mantle;

import com.volmit.adapt.util.arcane.multiburst.BurstExecutor;
import com.volmit.adapt.util.arcane.multiburst.MultiBurst;
import com.volmit.adapt.util.arcane.spatial.mantle.MantleChunk;
import com.volmit.adapt.util.arcane.spatial.mantle.MantleRegion;
import com.volmit.adapt.util.arcane.spatial.matter.Matter;
import com.volmit.adapt.util.arcane.spatial.matter.MatterSlice;
import com.volmit.adapt.util.arcane.spatial.parallel.HyperLock;
import com.volmit.adapt.util.arcane.spatial.util.CompressedNumbers;
import com.volmit.adapt.util.arcane.spatial.util.Consume;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

public class Mantle {
    private final File dataFolder;
    private final int worldHeight;
    private final Map<Long, Long> lastUse;
    private final Map<Long, MantleRegion> loadedRegions;
    private final HyperLock hyperLock = new HyperLock();
    private final Set<Long> unload;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final MultiBurst ioBurst;
    private final AtomicBoolean io;

    public Mantle(File file, int n) {
        this.dataFolder = file;
        this.worldHeight = n;
        this.io = new AtomicBoolean(false);
        this.unload = new HashSet<Long>();
        this.loadedRegions = new HashMap<Long, MantleRegion>();
        this.lastUse = new HashMap<Long, Long>();
        this.ioBurst = MultiBurst.burst;
    }

    public void clear() {
        this.loadedRegions.clear();
        this.lastUse.clear();
        this.unload.clear();
        this.hyperLock.clear();
        if (this.dataFolder.exists() && this.dataFolder.isDirectory()) {
            for (File file : this.dataFolder.listFiles()) {
                file.delete();
            }
        }
        this.dataFolder.delete();
    }

    public static File fileForRegion(File file, int n, int n2) {
        return Mantle.fileForRegion(file, Mantle.key(n, n2));
    }

    public static File fileForRegion(File file, Long l) {
        File file2 = new File(file, "p." + l + ".ttp");
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        return file2;
    }

    public static Long key(int n, int n2) {
        return CompressedNumbers.i2(n, n2);
    }

    public MantleChunk getChunk(int n, int n2) {
        return this.get(n >> 5, n2 >> 5).getOrCreate(n & 0x1F, n2 & 0x1F);
    }

    public void deleteChunk(int n, int n2) {
        this.get(n >> 5, n2 >> 5).delete(n & 0x1F, n2 & 0x1F);
    }

    public boolean hasTectonicPlate(int n, int n2) {
        Long l = Mantle.key(n, n2);
        return this.loadedRegions.containsKey(l) || Mantle.fileForRegion(this.dataFolder, l).exists();
    }

    public <T> void iterateChunk(int n, int n2, Class<T> clazz, Consume.Four<Integer, Integer, Integer, T> four) {
        if (!this.hasTectonicPlate(n >> 5, n2 >> 5)) {
            return;
        }
        this.get(n >> 5, n2 >> 5).getOrCreate(n & 0x1F, n2 & 0x1F).iterate(clazz, four);
    }

    public <T> void set(int n, int n2, int n3, T t) {
        if (this.closed.get()) {
            throw new RuntimeException("The Mantle is closed");
        }
        if (n2 < 0 || n2 >= this.worldHeight) {
            return;
        }
        Matter matter = this.get(n >> 4 >> 5, n3 >> 4 >> 5).getOrCreate(n >> 4 & 0x1F, n3 >> 4 & 0x1F).getOrCreate(n2 >> 4);
        matter.slice(matter.getClass(t)).set(n & 0xF, n2 & 0xF, n3 & 0xF, t);
    }

    public <T> void remove(int n, int n2, int n3, Class<T> clazz) {
        if (this.closed.get()) {
            throw new RuntimeException("The Mantle is closed");
        }
        if (n2 < 0 || n2 >= this.worldHeight) {
            return;
        }
        Matter matter = this.get(n >> 4 >> 5, n3 >> 4 >> 5).getOrCreate(n >> 4 & 0x1F, n3 >> 4 & 0x1F).getOrCreate(n2 >> 4);
        matter.slice(clazz).set(n & 0xF, n2 & 0xF, n3 & 0xF, null);
    }

    public <T> T get(int n, int n2, int n3, Class<T> clazz) {
        if (this.closed.get()) {
            throw new RuntimeException("The Mantle is closed");
        }
        if (!this.hasTectonicPlate(n >> 4 >> 5, n3 >> 4 >> 5)) {
            return null;
        }
        if (n2 < 0 || n2 >= this.worldHeight) {
            return null;
        }
        return this.get(n >> 4 >> 5, n3 >> 4 >> 5).getOrCreate(n >> 4 & 0x1F, n3 >> 4 & 0x1F).getOrCreate(n2 >> 4).slice(clazz).get(n & 0xF, n2 & 0xF, n3 & 0xF);
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public synchronized void close() {
        if (this.closed.get()) {
            return;
        }
        this.closed.set(true);
        this.saveAll();
        this.loadedRegions.clear();
    }

    public synchronized void trim(long l) {
        if (this.closed.get()) {
            throw new RuntimeException("The Mantle is closed");
        }
        this.io.set(true);
        this.unload.clear();
        for (Long l2 : this.lastUse.keySet()) {
            this.hyperLock.withLong(l2, () -> {
                if (System.currentTimeMillis() - this.lastUse.get(l2) >= l) {
                    this.unload.add(l2);
                }
            });
        }
        for (Long l2 : this.unload) {
            this.hyperLock.withLong(l2, () -> {
                MantleRegion mantleRegion = this.loadedRegions.remove(l2);
                this.lastUse.remove(l2);
                try {
                    mantleRegion.write(Mantle.fileForRegion(this.dataFolder, l2));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            });
        }
        this.io.set(false);
    }

    private MantleRegion get(int n, int n2) {
        MantleRegion mantleRegion;
        if (this.io.get()) {
            try {
                return this.getSafe(n, n2).get();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
        }
        if ((mantleRegion = this.loadedRegions.get(Mantle.key(n, n2))) != null) {
            return mantleRegion;
        }
        try {
            return this.getSafe(n, n2).get();
        }
        catch (InterruptedException | ExecutionException exception) {
            exception.printStackTrace();
            return this.get(n, n2);
        }
    }

    private Future<MantleRegion> getSafe(int n, int n2) {
        Long l = Mantle.key(n, n2);
        MantleRegion mantleRegion = this.loadedRegions.get(l);
        if (mantleRegion != null) {
            this.lastUse.put(l, System.currentTimeMillis());
            return CompletableFuture.completedFuture(mantleRegion);
        }
        return this.ioBurst.completeValue(() -> this.hyperLock.withResult(n, n2, () -> {
            this.lastUse.put(l, System.currentTimeMillis());
            MantleRegion mantleRegion = this.loadedRegions.get(l);
            if (mantleRegion != null) {
                return mantleRegion;
            }
            File file = Mantle.fileForRegion(this.dataFolder, n, n2);
            if (file.exists()) {
                try {
                    mantleRegion = MantleRegion.read(this.worldHeight, file);
                    this.loadedRegions.put(l, mantleRegion);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    mantleRegion = new MantleRegion(this.worldHeight, n, n2);
                    this.loadedRegions.put(l, mantleRegion);
                }
                return mantleRegion;
            }
            mantleRegion = new MantleRegion(this.worldHeight, n, n2);
            this.loadedRegions.put(l, mantleRegion);
            return mantleRegion;
        }));
    }

    public void saveAll() {
        if (this.loadedRegions.isEmpty()) {
            return;
        }
        BurstExecutor burstExecutor = this.ioBurst.burst(this.loadedRegions.size());
        for (Long l : this.loadedRegions.keySet()) {
            burstExecutor.queue(() -> {
                try {
                    if (!this.dataFolder.exists()) {
                        this.dataFolder.mkdirs();
                    }
                    this.loadedRegions.get(l).write(Mantle.fileForRegion(this.dataFolder, l));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            });
        }
        try {
            burstExecutor.complete();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public int getWorldHeight() {
        return this.worldHeight;
    }

    public void deleteChunkSlice(int n, int n2, Class<?> clazz) {
        this.getChunk(n, n2).deleteSlices(clazz);
    }

    public int getLoadedRegionCount() {
        return this.loadedRegions.size();
    }

    public <T> void set(int n, int n2, int n3, MatterSlice<T> matterSlice) {
        if (matterSlice.isEmpty()) {
            return;
        }
        matterSlice.iterateSync((n4, n5, n6, object) -> this.set(n + n4, n2 + n5, n3 + n6, object));
    }

    public boolean isChunkLoaded(int n, int n2) {
        return this.loadedRegions.containsKey(Mantle.key(n >> 5, n2 >> 5));
    }

    public Map<Long, MantleRegion> getLoadedRegions() {
        return this.loadedRegions;
    }
}

