/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.matter;

import com.volmit.adapt.util.arcane.spatial.matter.Matter;
import com.volmit.adapt.util.arcane.spatial.matter.MatterHeader;
import com.volmit.adapt.util.arcane.spatial.matter.MatterSlice;
import com.volmit.adapt.util.arcane.spatial.matter.slices.BooleanMatter;
import com.volmit.adapt.util.arcane.spatial.matter.slices.ByteMatter;
import com.volmit.adapt.util.arcane.spatial.matter.slices.DoubleMatter;
import com.volmit.adapt.util.arcane.spatial.matter.slices.FloatMatter;
import com.volmit.adapt.util.arcane.spatial.matter.slices.IntMatter;
import com.volmit.adapt.util.arcane.spatial.matter.slices.LongMatter;
import com.volmit.adapt.util.arcane.spatial.matter.slices.ShortMatter;
import com.volmit.adapt.util.arcane.spatial.matter.slices.StringMatter;
import java.util.HashMap;
import java.util.Map;

public class SpatialMatter
implements Matter {
    protected static final Map<Class<?>, MatterSlice<?>> slicers = new HashMap();
    private final MatterHeader header;
    private final int width;
    private final int height;
    private final int depth;
    private final Map<Class<?>, MatterSlice<?>> sliceMap;

    public SpatialMatter(int n, int n2, int n3) {
        if (n < 1 || n2 < 1 || n3 < 1) {
            throw new RuntimeException("Invalid Matter Size " + n + "x" + n2 + "x" + n3);
        }
        this.width = n;
        this.height = n2;
        this.depth = n3;
        this.header = new MatterHeader();
        this.sliceMap = new HashMap();
    }

    public static void registerSliceType(MatterSlice<?> matterSlice) {
        slicers.put(matterSlice.getType(), matterSlice);
    }

    private static void registerSliceType(Class<?> clazz, MatterSlice<?> matterSlice) {
        slicers.put(clazz, matterSlice);
    }

    @Override
    public <T> MatterSlice<T> createSlice(Class<T> clazz, Matter matter) {
        MatterSlice<?> matterSlice = slicers.get(this.getClass(clazz));
        if (matterSlice == null) {
            return null;
        }
        try {
            return (MatterSlice)matterSlice.getClass().getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(this.getWidth(), this.getHeight(), this.getDepth());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    @Override
    public MatterHeader getHeader() {
        return this.header;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public Map<Class<?>, MatterSlice<?>> getSliceMap() {
        return this.sliceMap;
    }

    static {
        SpatialMatter.registerSliceType(new DoubleMatter());
        SpatialMatter.registerSliceType(new ByteMatter());
        SpatialMatter.registerSliceType(new FloatMatter());
        SpatialMatter.registerSliceType(new ShortMatter());
        SpatialMatter.registerSliceType(new BooleanMatter());
        SpatialMatter.registerSliceType(new IntMatter());
        SpatialMatter.registerSliceType(new LongMatter());
        SpatialMatter.registerSliceType(new StringMatter());
    }
}

