/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.arcane.spatial.parallel;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.volmit.adapt.util.arcane.spatial.util.CompressedNumbers;
import com.volmit.adapt.util.arcane.spatial.util.Run;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class HyperLock {
    private final ConcurrentLinkedHashMap<Long, ReentrantLock> locks;
    private boolean enabled = true;
    private boolean fair = false;

    public HyperLock() {
        this(1024, false);
    }

    public void clear() {
        for (Long l : new HashSet(this.locks.keySet())) {
            if (((ReentrantLock)this.locks.get((Object)l)).isLocked()) continue;
            this.locks.remove((Object)l);
        }
    }

    public HyperLock(int n) {
        this(n, false);
    }

    public HyperLock(int n, boolean bl) {
        this.fair = bl;
        this.locks = new ConcurrentLinkedHashMap.Builder().initialCapacity(n).maximumWeightedCapacity((long)n).concurrencyLevel(32).build();
    }

    public void with(int n, int n2, Runnable runnable) {
        this.lock(n, n2);
        runnable.run();
        this.unlock(n, n2);
    }

    public void withLong(long l, Runnable runnable) {
        this.lock(CompressedNumbers.i2a(l), CompressedNumbers.i2b(l));
        runnable.run();
        this.unlock(CompressedNumbers.i2a(l), CompressedNumbers.i2b(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withNasty(int n, int n2, Run.Throwable throwable) {
        this.lock(n, n2);
        Throwable throwable2 = null;
        try {
            throwable.run();
        }
        catch (Throwable throwable3) {
            throwable2 = throwable3;
        }
        finally {
            this.unlock(n, n2);
            if (throwable2 != null) {
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withIO(int n, int n2, Run.IO iO) {
        block5: {
            this.lock(n, n2);
            IOException iOException = null;
            try {
                iO.run();
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            finally {
                this.unlock(n, n2);
                if (iOException == null) break block5;
                throw iOException;
            }
        }
    }

    public <T> T withResult(int n, int n2, Supplier<T> supplier) {
        this.lock(n, n2);
        T t = supplier.get();
        this.unlock(n, n2);
        return t;
    }

    public boolean tryLock(int n, int n2) {
        return this.getLock(n, n2).tryLock();
    }

    public boolean tryLock(int n, int n2, long l) {
        try {
            return this.getLock(n, n2).tryLock(l, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return false;
        }
    }

    private ReentrantLock getLock(int n, int n2) {
        return (ReentrantLock)this.locks.computeIfAbsent((Object)CompressedNumbers.i2(n, n2), l -> new ReentrantLock(this.fair));
    }

    public void lock(int n, int n2) {
        if (!this.enabled) {
            return;
        }
        this.getLock(n, n2).lock();
    }

    public void unlock(int n, int n2) {
        if (!this.enabled) {
            return;
        }
        this.getLock(n, n2).unlock();
    }

    public void disable() {
        this.enabled = false;
    }
}

