/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.command;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class SoundFeedback {
    private Sound sound;
    private float volume;
    private float pitch;

    public void play(Player player) {
        player.playSound(player.getLocation(), this.sound, this.volume, this.pitch);
    }

    private static float $default$volume() {
        return 1.0f;
    }

    private static float $default$pitch() {
        return 1.0f;
    }

    SoundFeedback(Sound sound, float f, float f2) {
        this.sound = sound;
        this.volume = f;
        this.pitch = f2;
    }

    public static SoundFeedbackBuilder builder() {
        return new SoundFeedbackBuilder();
    }

    public Sound sound() {
        return this.sound;
    }

    public float volume() {
        return this.volume;
    }

    public float pitch() {
        return this.pitch;
    }

    public SoundFeedback sound(Sound sound) {
        this.sound = sound;
        return this;
    }

    public SoundFeedback volume(float f) {
        this.volume = f;
        return this;
    }

    public SoundFeedback pitch(float f) {
        this.pitch = f;
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SoundFeedback)) {
            return false;
        }
        SoundFeedback soundFeedback = (SoundFeedback)object;
        if (!soundFeedback.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.volume(), soundFeedback.volume()) != 0) {
            return false;
        }
        if (Float.compare(this.pitch(), soundFeedback.pitch()) != 0) {
            return false;
        }
        Sound sound = this.sound();
        Sound sound2 = soundFeedback.sound();
        return !(sound == null ? sound2 != null : !sound.equals(sound2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof SoundFeedback;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + Float.floatToIntBits(this.volume());
        n2 = n2 * 59 + Float.floatToIntBits(this.pitch());
        Sound sound = this.sound();
        n2 = n2 * 59 + (sound == null ? 43 : sound.hashCode());
        return n2;
    }

    public String toString() {
        return "SoundFeedback(sound=" + this.sound() + ", volume=" + this.volume() + ", pitch=" + this.pitch() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class SoundFeedbackBuilder {
        private Sound sound;
        private boolean volume$set;
        private float volume$value;
        private boolean pitch$set;
        private float pitch$value;

        SoundFeedbackBuilder() {
        }

        public SoundFeedbackBuilder sound(Sound sound) {
            this.sound = sound;
            return this;
        }

        public SoundFeedbackBuilder volume(float f) {
            this.volume$value = f;
            this.volume$set = true;
            return this;
        }

        public SoundFeedbackBuilder pitch(float f) {
            this.pitch$value = f;
            this.pitch$set = true;
            return this;
        }

        public SoundFeedback build() {
            float f = this.volume$value;
            if (!this.volume$set) {
                f = SoundFeedback.$default$volume();
            }
            float f2 = this.pitch$value;
            if (!this.pitch$set) {
                f2 = SoundFeedback.$default$pitch();
            }
            return new SoundFeedback(this.sound, f, f2);
        }

        public String toString() {
            return "SoundFeedback.SoundFeedbackBuilder(sound=" + this.sound + ", volume$value=" + this.volume$value + ", pitch$value=" + this.pitch$value + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

