/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.extensions.java.lang.Math;

import com.volmit.adapt.util.manifold.ext.rt.api.Extension;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.regex.Matcher;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

@Extension
public class XMath {
    private static final int precision = 128;
    private static final int modulus = 46080;
    private static final float[] sin;
    public static int tick;

    @Extension
    public static double rangeScale(double d, double d2, double d3, double d4, double d5) {
        return d + (d2 - d) * ((d5 - d3) / (d4 - d3));
    }

    @Extension
    public static double lerpInverse(double d, double d2, double d3) {
        return XMath.rangeScale(0.0, 1.0, d, d2, d3);
    }

    @Extension
    public static double lerp(double d, double d2, double d3) {
        return d + d3 * (d2 - d);
    }

    @Extension
    public static double bilerp(double d, double d2, double d3, double d4, double d5, double d6) {
        return XMath.lerp(XMath.lerp(d, d2, d5), XMath.lerp(d3, d4, d5), d6);
    }

    @Extension
    public static double trilerp(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11) {
        return XMath.lerp(XMath.bilerp(d, d2, d3, d4, d9, d10), XMath.bilerp(d5, d6, d7, d8, d9, d10), d11);
    }

    @Extension
    public static double dclip(double d, double d2, double d3) {
        return Math.min(d3, Math.max(d2, d));
    }

    @Extension
    public static boolean r(Double d) {
        if (d == null) {
            return Math.random() < 0.5;
        }
        return Math.random() < d;
    }

    @Extension
    public static double tps(long l, int n) {
        return 20.0 * ((double)l / 5.0E7) / (double)n;
    }

    @Extension
    public static double ticksFromNS(long l) {
        return (double)l / 5.0E7;
    }

    @Extension
    public static long ns() {
        return System.nanoTime();
    }

    @Extension
    public static long ms() {
        return System.currentTimeMillis();
    }

    @Extension
    public static double evaluate(String string, Double ... doubleArray) {
        for (int i = 0; i < doubleArray.length; ++i) {
            String string2 = "$" + i;
            if (!string.contains(string2)) continue;
            string = string.replaceAll(Matcher.quoteReplacement(string2), "" + doubleArray[i]);
        }
        return XMath.evaluate(string);
    }

    @Extension
    public static double evaluate(String string) {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("JavaScript");
        return Double.parseDouble(scriptEngine.eval(string).toString());
    }

    @Extension
    public static boolean within(int n, int n2, int n3) {
        return n3 >= n && n3 <= n2;
    }

    @Extension
    public static long epochDays() {
        return XMath.epochDays(XMath.ms());
    }

    @Extension
    public static long epochDays(long l) {
        return l / 1000L / 60L / 60L / 24L;
    }

    @Extension
    public static double constrainToRange(double d, double d2, double d3) {
        return Math.min(Math.max(d, d2), d3);
    }

    @Extension
    public static double sq(double d) {
        return d * d;
    }

    @Extension
    public static int sq(int n) {
        return n * n;
    }

    @Extension
    public static float sq(float f) {
        return f * f;
    }

    @Extension
    public static float sinLookup(int n) {
        return n >= 0 ? sin[n % 46080] : -sin[-n % 46080];
    }

    @Extension
    public static boolean interval(int n) {
        return tick % (n <= 0 ? 1 : n) == 0;
    }

    static {
        IBootstrap.dasBoot();
        sin = new float[46080];
        tick = 0;
        for (int i = 0; i < sin.length; ++i) {
            XMath.sin[i] = (float)Math.sin((double)i * Math.PI / 23040.0);
        }
    }
}

