/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.manifold.ext.rt.proxy;

import com.volmit.adapt.util.manifold.ext.rt.proxy.ProxyGenerator;
import com.volmit.adapt.util.manifold.ext.rt.proxy.WeakCache;
import com.volmit.adapt.util.manifold.util.JreUtil;
import com.volmit.adapt.util.manifold.util.ReflectUtil;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = -2222568056686623797L;
    private static final Class<?>[] constructorParams = new Class[]{InvocationHandler.class};
    private static final WeakCache<ClassLoader, Class<?>[], Class<?>> proxyClassCache = new WeakCache(new KeyFactory(), new ProxyClassFactory());
    protected InvocationHandler h;
    private static final Object key0 = new Object();

    private Proxy() {
    }

    protected Proxy(InvocationHandler invocationHandler) {
        Objects.requireNonNull(invocationHandler);
        this.h = invocationHandler;
    }

    @CallerSensitive
    public static Class<?> getProxyClass(ClassLoader classLoader, Class<?> ... classArray) {
        Class[] classArray2 = (Class[])classArray.clone();
        return Proxy.getProxyClass0(classLoader, classArray2);
    }

    private static void checkProxyAccess(Class<?> clazz, ClassLoader classLoader, Class<?> ... classArray) {
    }

    private static Class<?> getProxyClass0(ClassLoader classLoader, Class<?> ... classArray) {
        if (classArray.length > 65535) {
            throw new IllegalArgumentException("interface limit exceeded");
        }
        return proxyClassCache.get(classLoader, classArray);
    }

    @CallerSensitive
    public static Object newProxyInstance(ClassLoader classLoader, Class<?>[] classArray, InvocationHandler invocationHandler) {
        Objects.requireNonNull(invocationHandler);
        Class[] classArray2 = (Class[])classArray.clone();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            Proxy.checkProxyAccess(Reflection.getCallerClass(), classLoader, classArray2);
        }
        Class<?> clazz = Proxy.getProxyClass0(classLoader, classArray2);
        try {
            if (securityManager != null) {
                Proxy.checkNewProxyPermission(Reflection.getCallerClass(), clazz);
            }
            final Constructor<?> constructor = clazz.getConstructor(constructorParams);
            InvocationHandler invocationHandler2 = invocationHandler;
            if (!Modifier.isPublic(clazz.getModifiers())) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        constructor.setAccessible(true);
                        return null;
                    }
                });
            }
            return constructor.newInstance(invocationHandler);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new InternalError(reflectiveOperationException.toString(), reflectiveOperationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new InternalError(throwable.toString(), throwable);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError(noSuchMethodException.toString(), noSuchMethodException);
        }
    }

    private static void checkNewProxyPermission(Class<?> clazz, Class<?> clazz2) {
    }

    public static boolean isProxyClass(Class<?> clazz) {
        return Proxy.class.isAssignableFrom(clazz) && proxyClassCache.containsValue(clazz);
    }

    @CallerSensitive
    public static InvocationHandler getInvocationHandler(Object object) {
        if (!Proxy.isProxyClass(object.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        Proxy proxy = (Proxy)object;
        return proxy.h;
    }

    public static Class<?> defineProxyClass(Object object, String string, byte[] byArray, int n, int n2, ClassLoader classLoader) {
        if (!JreUtil.isJava8()) {
            classLoader = (ClassLoader)ReflectUtil.method(object, "getClassLoader", new Class[0]).invoke(new Object[0]);
        }
        return (Class)ReflectUtil.method(classLoader, "defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE).invoke(string, byArray, n, n2);
    }

    private static final class ProxyClassFactory
    implements BiFunction<ClassLoader, Class<?>[], Class<?>> {
        private static final String proxyClassNamePrefix = "$ManProxy";
        private static final AtomicLong nextUniqueNumber = new AtomicLong();

        private ProxyClassFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Class<?> apply(ClassLoader classLoader, Class<?>[] classArray) {
            Class<?> clazz4;
            void object2;
            IdentityHashMap identityHashMap = new IdentityHashMap(classArray.length);
            Object object = classArray;
            int n = ((Class<?>[])object).length;
            boolean bl = false;
            while (object2 < n) {
                Class<?> clazz2 = object[object2];
                Class<?> clazz3 = null;
                try {
                    clazz3 = Class.forName(clazz2.getName(), false, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (clazz3 != clazz2) {
                    throw new IllegalArgumentException(clazz2 + " is not visible from class loader");
                }
                if (!clazz3.isInterface()) {
                    throw new IllegalArgumentException(clazz3.getName() + " is not an interface");
                }
                if (identityHashMap.put(clazz3, Boolean.TRUE) != null) {
                    throw new IllegalArgumentException("repeated interface: " + clazz3.getName());
                }
                ++object2;
            }
            object = null;
            n = 17;
            for (Class<?> clazz4 : classArray) {
                String string;
                int n2 = clazz4.getModifiers();
                if (Modifier.isPublic(n2)) continue;
                n = 16;
                String string2 = clazz4.getName();
                int n3 = string2.lastIndexOf(46);
                String string3 = string = n3 == -1 ? "" : string2.substring(0, n3 + 1);
                if (object == null) {
                    object = string;
                    continue;
                }
                if (string.equals(object)) continue;
                throw new IllegalArgumentException("non-public interfaces from different packages");
            }
            Object var6_9 = null;
            if (!JreUtil.isJava8()) {
                if (object != null && ((String)object).endsWith(".")) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                Object object3 = ReflectUtil.constructor("java.lang.reflect.Proxy$ProxyBuilder", ClassLoader.class, List.class).newInstance(classLoader, Arrays.asList(classArray));
                Object object4 = ReflectUtil.field(object3, "module").get();
                String string = (String)ReflectUtil.method(object4, "getName", new Class[0]).invoke(new Object[0]);
                clazz4 = ReflectUtil.type("java.lang.Module");
                Object object5 = ReflectUtil.method(Proxy.class, "getModule", new Class[0]).invoke(new Object[0]);
                ReflectUtil.method("jdk.internal.module.Modules", "addReads", clazz4, clazz4).invokeStatic(object4, object5);
                if (object == null) {
                    object = (Boolean)ReflectUtil.method(object4, "isNamed", new Class[0]).invoke(new Object[0]) != false ? "com.sun.proxy." + string : "com.sun.proxy";
                }
                ReflectUtil.method("jdk.internal.module.Modules", "addExports", clazz4, String.class, clazz4).invokeStatic(object4, object, object5);
                ReflectUtil.method("jdk.internal.module.Modules", "addOpens", clazz4, String.class, clazz4).invokeStatic(object4, object, object5);
                object = (String)object + '.';
            }
            if (object == null) {
                object = "com.sun.proxy.";
            }
            long l = nextUniqueNumber.getAndIncrement();
            clazz4 = (String)object + proxyClassNamePrefix + l;
            byte[] byArray = ProxyGenerator.generateProxyClass((String)((Object)clazz4), classArray, n);
            try {
                void var6_11;
                return Proxy.defineProxyClass(var6_11, (String)((Object)clazz4), byArray, 0, byArray.length, classLoader);
            }
            catch (ClassFormatError classFormatError) {
                throw new IllegalArgumentException(classFormatError.toString());
            }
        }
    }

    private static final class KeyFactory
    implements BiFunction<ClassLoader, Class<?>[], Object> {
        private KeyFactory() {
        }

        @Override
        public Object apply(ClassLoader classLoader, Class<?>[] classArray) {
            switch (classArray.length) {
                case 1: {
                    return new Key1(classArray[0]);
                }
                case 2: {
                    return new Key2(classArray[0], classArray[1]);
                }
                case 0: {
                    return key0;
                }
            }
            return new KeyX(classArray);
        }
    }

    private static final class KeyX {
        private final int hash;
        private final WeakReference<Class<?>>[] refs;

        KeyX(Class<?>[] classArray) {
            this.hash = Arrays.hashCode(classArray);
            this.refs = new WeakReference[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                this.refs[i] = new WeakReference(classArray[i]);
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            return this == object || object != null && object.getClass() == KeyX.class && KeyX.equals(this.refs, ((KeyX)object).refs);
        }

        private static boolean equals(WeakReference<Class<?>>[] weakReferenceArray, WeakReference<Class<?>>[] weakReferenceArray2) {
            if (weakReferenceArray.length != weakReferenceArray2.length) {
                return false;
            }
            for (int i = 0; i < weakReferenceArray.length; ++i) {
                Class clazz = (Class)weakReferenceArray[i].get();
                if (clazz != null && clazz == weakReferenceArray2[i].get()) continue;
                return false;
            }
            return true;
        }
    }

    private static final class Key2
    extends WeakReference<Class<?>> {
        private final int hash;
        private final WeakReference<Class<?>> ref2;

        Key2(Class<?> clazz, Class<?> clazz2) {
            super(clazz);
            this.hash = 31 * clazz.hashCode() + clazz2.hashCode();
            this.ref2 = new WeakReference(clazz2);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            Class clazz;
            Class clazz2;
            return this == object || object != null && object.getClass() == Key2.class && (clazz2 = (Class)this.get()) != null && clazz2 == ((Key2)object).get() && (clazz = (Class)this.ref2.get()) != null && clazz == ((Key2)object).ref2.get();
        }
    }

    private static final class Key1
    extends WeakReference<Class<?>> {
        private final int hash;

        Key1(Class<?> clazz) {
            super(clazz);
            this.hash = clazz.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            Class clazz;
            return this == object || object != null && object.getClass() == Key1.class && (clazz = (Class)this.get()) != null && clazz == ((Key1)object).get();
        }
    }
}

