/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.manifold.rt.api.util;

import com.volmit.adapt.util.manifold.util.JreUtil;
import com.volmit.adapt.util.manifold.util.ReflectUtil;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;

public class ServiceUtil {
    public static <C> Set<C> loadRegisteredServices(Set<C> set, Class<C> clazz, ClassLoader classLoader) {
        C c;
        Iterator<C> iterator;
        ServiceLoader<C> serviceLoader = ServiceLoader.load(clazz);
        try {
            ServiceUtil.hackServiceLoaderToHandleProxyFactoryForJpms(serviceLoader, clazz, null);
            iterator = serviceLoader.iterator();
            while (iterator.hasNext()) {
                try {
                    c = iterator.next();
                    if (!ServiceUtil.isAbsent(set, c)) continue;
                    set.add(c);
                }
                catch (ServiceConfigurationError serviceConfigurationError) {}
            }
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            // empty catch block
        }
        if (Thread.currentThread().getContextClassLoader() != classLoader) {
            serviceLoader = ServiceLoader.load(clazz, classLoader);
            ServiceUtil.hackServiceLoaderToHandleProxyFactoryForJpms(serviceLoader, clazz, classLoader);
            iterator = serviceLoader.iterator();
            while (iterator.hasNext()) {
                try {
                    c = iterator.next();
                    if (!ServiceUtil.isAbsent(set, c)) continue;
                    set.add(c);
                }
                catch (ServiceConfigurationError serviceConfigurationError) {}
            }
        }
        return set;
    }

    private static <C> void hackServiceLoaderToHandleProxyFactoryForJpms(ServiceLoader<C> serviceLoader, Class<?> clazz, ClassLoader classLoader) {
        if (!JreUtil.isJava9Modular_runtime() || !clazz.getSimpleName().equals("IProxyFactory_gen")) {
            return;
        }
        ReflectUtil.field(serviceLoader, "lookupIterator1").set(ReflectUtil.constructor("com.volmit.adapt.util.manifold.util.LazyClassPathLookupIterator", Class.class, ClassLoader.class).newInstance(clazz, classLoader == null ? ReflectUtil.field(serviceLoader, "loader").get() : classLoader));
    }

    static <C> boolean isAbsent(Set<C> set, C c) {
        for (C c2 : set) {
            if (!c2.getClass().equals(c.getClass())) continue;
            return false;
        }
        return true;
    }
}

