/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.util.manifold.util;

import com.volmit.adapt.util.manifold.util.MethodScore;
import com.volmit.adapt.util.manifold.util.PrimitiveUtil;
import com.volmit.adapt.util.manifold.util.TypeAncestry;
import com.volmit.adapt.util.manifold.util.concurrent.Cache;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class MethodScorer {
    public static final int BOXED_COERCION_SCORE = 10;
    public static final int PRIMITIVE_COERCION_SCORE = 24;
    private static volatile MethodScorer INSTANCE = null;
    private final Cache<Pair<Class, Class>, Integer> _typeScoreCache = Cache.make("Type Score Cache", 10000, pair -> this._addToScoreForTypes((Class)((Pair)pair).fst, (Class)((Pair)pair).snd));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MethodScorer instance() {
        if (INSTANCE != null) return INSTANCE;
        Class<MethodScorer> clazz = MethodScorer.class;
        synchronized (MethodScorer.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new MethodScorer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private MethodScorer() {
    }

    public List<MethodScore> scoreMethods(List<Method> list, List<Class> list2, Class clazz) {
        ArrayList<MethodScore> arrayList = new ArrayList<MethodScore>();
        for (Method method : list) {
            arrayList.add(this.scoreMethod(method, list2, clazz));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public MethodScore scoreMethod(Method method, List<Class> list, Class clazz) {
        MethodScore methodScore = new MethodScore(null);
        methodScore.setValid(true);
        methodScore.setMethod(method);
        methodScore.incScore(this.scoreMethod(methodScore, method, list, clazz));
        return methodScore;
    }

    public int scoreMethod(MethodScore methodScore, Method method, List<Class> list, Class clazz) {
        int n;
        Class<?>[] classArray = method.getParameterTypes();
        int n2 = 0;
        for (n = 0; n < list.size(); ++n) {
            if (classArray.length <= n) {
                n2 += 128;
                methodScore.setErrant(true);
                continue;
            }
            Class clazz2 = list.get(n);
            int n3 = this.addToScoreForTypes(classArray[n], clazz2);
            n2 += n3;
            if (n3 < 126) continue;
            methodScore.setErrant(true);
        }
        for (n = list.size(); n < classArray.length; ++n) {
            n2 += 127;
            methodScore.setErrant(true);
        }
        if (method.isVarArgs()) {
            ++n2;
        }
        if (method.getReturnType() != Void.TYPE) {
            n = this.addToScoreForTypes(clazz, method.getReturnType());
            n2 += n;
            if (n >= 126) {
                methodScore.setErrant(true);
            }
        }
        return n2;
    }

    public int addToScoreForTypes(Class clazz, Class clazz2) {
        if (clazz2 == clazz) {
            return 0;
        }
        return this._typeScoreCache.get(new Pair<Class, Class>(clazz, clazz2));
    }

    public int _addToScoreForTypes(Class<?> clazz, Class clazz2) {
        Class clazz3;
        Class clazz4;
        Class clazz5;
        int n = clazz.equals(clazz2) ? 0 : (!clazz.isPrimitive() && clazz2 == Void.TYPE ? 1 : (this.arePrimitiveTypesCompatible(clazz, clazz2) ? PrimitiveUtil.getPriorityOf(clazz, clazz2) : (PrimitiveUtil.isBoxedTypeFor(clazz, clazz2) || PrimitiveUtil.isBoxedTypeFor(clazz2, clazz) ? 10 : (clazz2.isPrimitive() && PrimitiveUtil.isBoxed(clazz) && this.arePrimitiveTypesCompatible(clazz5 = PrimitiveUtil.getPrimitiveType(clazz), clazz2) ? 10 + PrimitiveUtil.getPriorityOf(clazz5, clazz2) : (PrimitiveUtil.isBoxed(clazz2) && clazz.isPrimitive() && this.arePrimitiveTypesCompatible(clazz, clazz4 = PrimitiveUtil.getPrimitiveType(clazz2)) ? 10 + PrimitiveUtil.getPriorityOf(clazz, clazz4) : (PrimitiveUtil.isBoxed(clazz2) && PrimitiveUtil.isBoxed(clazz) && this.arePrimitiveTypesCompatible(clazz5 = PrimitiveUtil.getPrimitiveType(clazz), clazz4 = PrimitiveUtil.getPrimitiveType(clazz2)) ? 20 + PrimitiveUtil.getPriorityOf(clazz5, clazz4) : (clazz2.isPrimitive() && clazz2 != Void.TYPE && !clazz.isPrimitive() && clazz.isAssignableFrom(clazz3 = PrimitiveUtil.getBoxedType(clazz2)) ? 10 + this.addDegreesOfSeparation(clazz, clazz3) : (clazz.isAssignableFrom(clazz2) ? this.addDegreesOfSeparation(clazz, clazz2) : 126))))))));
        return n;
    }

    private boolean arePrimitiveTypesCompatible(Class clazz, Class clazz2) {
        return PrimitiveUtil.arePrimitiveTypesAssignable(clazz, clazz2) || clazz.isPrimitive() && clazz2.isPrimitive() && clazz != Boolean.TYPE && clazz2 != Boolean.TYPE && clazz != Character.TYPE && clazz2 != Character.TYPE && clazz != Void.TYPE && clazz2 != Void.TYPE && PrimitiveUtil.losesInformation(clazz2, clazz) <= 1;
    }

    public int addDegreesOfSeparation(Class clazz, Class clazz2) {
        return this.addDegreesOfSeparation(clazz, TypeAncestry.instance().getTypesInAncestry(clazz2));
    }

    public int addDegreesOfSeparation(Class<?> clazz, Set<? extends Class> set) {
        int n = 0;
        for (Class clazz2 : set) {
            if (clazz == clazz2 || !clazz.isAssignableFrom(clazz2)) continue;
            ++n;
        }
        return n;
    }

    static class Pair<F, S> {
        private F fst;
        private S snd;

        public Pair(F f, S s) {
            this.fst = f;
            this.snd = s;
        }
    }
}

