/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.api;

import com.hm.achievement.AdvancedAchievements;
import com.hm.achievement.api.AdvancedAchievementsAPI;
import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.AbstractDatabaseManager;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.domain.Achievement;
import com.hm.achievement.domain.AwardedAchievement;
import com.hm.achievement.utils.StatisticIncreaseHandler;
import com.hm.apache.commons.lang3.StringUtils;
import com.hm.apache.commons.lang3.math.NumberUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

@Singleton
public class AdvancedAchievementsBukkitAPI
implements AdvancedAchievementsAPI {
    private final AdvancedAchievements advancedAchievements;
    private final CacheManager cacheManager;
    private final AbstractDatabaseManager databaseManager;
    private final StatisticIncreaseHandler statisticIncreaseHandler;
    private final AchievementMap achievementMap;

    @Inject
    AdvancedAchievementsBukkitAPI(AdvancedAchievements advancedAchievements, CacheManager cacheManager, AbstractDatabaseManager abstractDatabaseManager, StatisticIncreaseHandler statisticIncreaseHandler, AchievementMap achievementMap) {
        this.advancedAchievements = advancedAchievements;
        this.cacheManager = cacheManager;
        this.databaseManager = abstractDatabaseManager;
        this.statisticIncreaseHandler = statisticIncreaseHandler;
        this.achievementMap = achievementMap;
    }

    @Override
    public AdvancedAchievementsAPI.Version getAdvancedAchievementsVersion() {
        String[] stringArray = StringUtils.split(this.advancedAchievements.getDescription().getVersion(), '.');
        int n = stringArray.length > 0 ? NumberUtils.toInt(stringArray[0]) : 0;
        int n2 = stringArray.length > 1 ? NumberUtils.toInt(stringArray[1]) : 0;
        int n3 = stringArray.length > 2 ? NumberUtils.toInt(stringArray[2]) : 0;
        return new AdvancedAchievementsAPI.Version(n, n2, n3);
    }

    @Override
    public boolean hasPlayerReceivedAchievement(UUID uUID, String string) {
        this.validateNotNull(uUID, "Player");
        this.validateNotEmpty(string, "Achievement Name");
        return this.cacheManager.hasPlayerAchievement(uUID, string);
    }

    @Override
    public List<Achievement> getAllAchievements() {
        return new ArrayList<Achievement>(this.achievementMap.getAll());
    }

    @Override
    public List<AwardedAchievement> getPlayerAchievements(UUID uUID) {
        this.validateNotNull(uUID, "Player");
        return this.databaseManager.getPlayerAchievementsList(uUID).stream().filter(awardedDBAchievement -> this.achievementMap.getForName(awardedDBAchievement.getName()) != null).map(awardedDBAchievement -> new AwardedAchievement(this.achievementMap.getForName(awardedDBAchievement.getName()), uUID, awardedDBAchievement.getDateAwarded())).collect(Collectors.toList());
    }

    @Override
    public int getPlayerTotalAchievements(UUID uUID) {
        this.validateNotNull(uUID, "Player");
        return this.cacheManager.getPlayerAchievements(uUID).size();
    }

    @Override
    public AdvancedAchievementsAPI.Rank getPlayerRank(UUID uUID, long l) {
        this.validateNotNull(uUID, "Player");
        Map<String, Integer> map = this.databaseManager.getTopList(l);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(map.values());
        Integer n = map.get(uUID.toString());
        if (n != null) {
            int n2 = arrayList.indexOf(n) + 1;
            return new AdvancedAchievementsAPI.Rank(n2, map.size());
        }
        return new AdvancedAchievementsAPI.Rank(Integer.MAX_VALUE, map.size());
    }

    @Override
    public List<UUID> getTopPlayers(int n, long l) {
        return this.databaseManager.getTopList(l).keySet().stream().limit(n).map(UUID::fromString).collect(Collectors.toList());
    }

    @Override
    public long getStatisticForNormalCategory(UUID uUID, NormalAchievements normalAchievements) {
        this.validateNotNull(uUID, "Player");
        this.validateNotNull(normalAchievements, "Category");
        if (Bukkit.isPrimaryThread()) {
            return this.cacheManager.getAndIncrementStatisticAmount(normalAchievements, uUID, 0);
        }
        return this.databaseManager.getNormalAchievementAmount(uUID, normalAchievements);
    }

    @Override
    public long getStatisticForMultipleCategory(UUID uUID, MultipleAchievements multipleAchievements, String string) {
        this.validateNotNull(uUID, "Player");
        this.validateNotNull(multipleAchievements, "Category");
        this.validateNotEmpty(string, "Sub-category");
        if (Bukkit.isPrimaryThread()) {
            return this.cacheManager.getAndIncrementStatisticAmount(multipleAchievements, string, uUID, 0);
        }
        return this.databaseManager.getMultipleAchievementAmount(uUID, multipleAchievements, string);
    }

    @Override
    public String getDisplayNameForName(String string) {
        this.validateNotEmpty(string, "Achievement Name");
        Achievement achievement = this.achievementMap.getForName(string);
        return achievement == null ? null : achievement.getDisplayName();
    }

    @Override
    public Map<UUID, Integer> getPlayersTotalAchievements() {
        return this.databaseManager.getPlayersAchievementsAmount();
    }

    @Override
    public void incrementCategoryForPlayer(NormalAchievements normalAchievements, Player player, int n) {
        this.validateNotNull(normalAchievements, "category");
        this.validateNotNull(player, "player");
        long l = this.cacheManager.getAndIncrementStatisticAmount(normalAchievements, player.getUniqueId(), n);
        this.statisticIncreaseHandler.checkThresholdsAndAchievements(player, normalAchievements, l);
    }

    @Override
    public void incrementCategoryForPlayer(MultipleAchievements multipleAchievements, String string, Player player, int n) {
        this.validateNotNull(multipleAchievements, "category");
        this.validateNotEmpty(string, "subcategory");
        this.validateNotNull(player, "player");
        long l = this.cacheManager.getAndIncrementStatisticAmount(multipleAchievements, string, player.getUniqueId(), n);
        this.statisticIncreaseHandler.checkThresholdsAndAchievements(player, multipleAchievements, string, l);
    }

    private void validateNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string + " cannot be null.");
        }
    }

    private void validateNotEmpty(String string, String string2) {
        if (StringUtils.isEmpty(string)) {
            throw new IllegalArgumentException(string2 + " cannot be empty.");
        }
    }
}

