/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.category;

import com.hm.achievement.category.Category;
import java.util.HashMap;
import java.util.Map;

public enum MultipleAchievements implements Category
{
    PLACES("Places", "blockid"),
    BREAKS("Breaks", "blockid"),
    KILLS("Kills", "mobname"),
    TARGETSSHOT("TargetsShot", "targetname"),
    CRAFTS("Crafts", "item"),
    BREEDING("Breeding", "mobname"),
    PLAYERCOMMANDS("PlayerCommands", "command"),
    CUSTOM("Custom", "customname"),
    JOBSREBORN("JobsReborn", "jobname"),
    EFFECTSHELD("EffectsHeld", "effect");

    private static final Map<String, MultipleAchievements> CATEGORY_NAMES_TO_ENUM;
    private final String categoryName;
    private final String subcategoryDBName;
    private final String dbName;
    private final String permNamePrefix;
    private final String permName;

    private MultipleAchievements(String string2, String string3) {
        this.categoryName = string2;
        this.subcategoryDBName = string3;
        this.dbName = this.name().toLowerCase();
        this.permNamePrefix = "achievement.count." + string2.toLowerCase() + '.';
        this.permName = this.permNamePrefix + '*';
    }

    public static MultipleAchievements getByName(String string) {
        return CATEGORY_NAMES_TO_ENUM.get(string);
    }

    public String toString() {
        return this.categoryName;
    }

    @Override
    public String toDBName() {
        return this.dbName;
    }

    @Override
    public String toPermName() {
        return this.permName;
    }

    @Override
    public String toChildPermName(String string) {
        return this.permNamePrefix + string;
    }

    public String toSubcategoryDBName() {
        return this.subcategoryDBName;
    }

    static {
        CATEGORY_NAMES_TO_ENUM = new HashMap<String, MultipleAchievements>();
        for (MultipleAchievements multipleAchievements : MultipleAchievements.values()) {
            CATEGORY_NAMES_TO_ENUM.put(multipleAchievements.categoryName, multipleAchievements);
        }
    }
}

