/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.executable;

import com.hm.achievement.command.executable.AbstractCommand;
import com.hm.achievement.command.external.CommandUtils;
import com.hm.apache.commons.lang3.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public abstract class AbstractParsableCommand
extends AbstractCommand {
    private String langPlayerOffline;
    private String langEntityNotPlayer;

    AbstractParsableCommand(YamlConfiguration yamlConfiguration, YamlConfiguration yamlConfiguration2, StringBuilder stringBuilder) {
        super(yamlConfiguration, yamlConfiguration2, stringBuilder);
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.langPlayerOffline = this.langConfig.getString("player-offline");
        this.langEntityNotPlayer = this.langConfig.getString("not-a-player");
    }

    abstract void onExecuteForPlayer(CommandSender var1, String[] var2, Player var3);

    @Override
    void onExecute(CommandSender commandSender, String[] stringArray) {
        String string = stringArray[stringArray.length - 1];
        Entity[] entityArray = CommandUtils.getTargets(commandSender, string);
        if (entityArray == null) {
            commandSender.sendMessage(this.pluginHeader + this.langEntityNotPlayer);
            return;
        }
        for (Entity entity : entityArray) {
            if (entity == null) {
                commandSender.sendMessage(this.pluginHeader + StringUtils.replaceOnce(this.langPlayerOffline, "PLAYER", string));
                break;
            }
            if (entity instanceof Player) {
                this.onExecuteForPlayer(commandSender, stringArray, (Player)entity);
                continue;
            }
            commandSender.sendMessage(this.pluginHeader + StringUtils.replaceOnce(this.langEntityNotPlayer, "ENTITY", entity.getName()));
        }
    }

    String parseAchievementName(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < stringArray.length - 1; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i == stringArray.length - 2) continue;
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }
}

