/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.executable;

import com.hm.achievement.AdvancedAchievements;
import com.hm.achievement.command.executable.AbstractCommand;
import com.hm.achievement.command.executable.CommandSpec;
import com.hm.achievement.config.RewardParser;
import com.hm.apache.commons.text.StringEscapeUtils;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;

@Singleton
@CommandSpec(name="info", permission="", minArgs=1, maxArgs=1)
public class InfoCommand
extends AbstractCommand {
    private final AdvancedAchievements advancedAchievements;
    private final RewardParser rewardParser;
    private String configDatabaseType;
    private String header;
    private String langVersionCommandDescription;
    private String langVersionCommandAuthor;
    private String langVersionCommandVersion;
    private String langVersionCommandWebsite;
    private String langVersionCommandVault;
    private String langVersionCommandPetmaster;
    private String langVersionCommandEssentials;
    private String langVersionCommandPlaceholderAPI;
    private String langVersionCommandDatabase;

    @Inject
    public InfoCommand(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, StringBuilder stringBuilder, AdvancedAchievements advancedAchievements, RewardParser rewardParser) {
        super(yamlConfiguration, yamlConfiguration2, stringBuilder);
        this.advancedAchievements = advancedAchievements;
        this.rewardParser = rewardParser;
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        ChatColor chatColor = ChatColor.getByChar((String)this.mainConfig.getString("Color"));
        String string = StringEscapeUtils.unescapeJava(this.mainConfig.getString("Icon"));
        this.configDatabaseType = this.mainConfig.getString("DatabaseType");
        this.header = chatColor + "------------ " + string + this.translateColorCodes(" &lAdvanced Achievements ") + chatColor + string + chatColor + " ------------";
        this.langVersionCommandDescription = this.pluginHeader.toString() + chatColor + this.langConfig.getString("version-command-description") + " " + ChatColor.GRAY + this.langConfig.getString("version-command-description-details");
        this.langVersionCommandVersion = this.pluginHeader.toString() + chatColor + this.langConfig.getString("version-command-version") + " " + ChatColor.GRAY + this.advancedAchievements.getDescription().getVersion();
        this.langVersionCommandAuthor = this.pluginHeader.toString() + chatColor + this.langConfig.getString("version-command-author") + " " + ChatColor.GRAY + (String)this.advancedAchievements.getDescription().getAuthors().get(0);
        this.langVersionCommandWebsite = this.pluginHeader.toString() + chatColor + this.langConfig.getString("version-command-website") + " " + ChatColor.GRAY + this.advancedAchievements.getDescription().getWebsite();
        String string2 = this.rewardParser.getEconomy() != null ? "&a\u2714" : "&4\u2718";
        this.langVersionCommandVault = this.pluginHeader.toString() + chatColor + this.langConfig.getString("version-command-vault") + " " + ChatColor.GRAY + this.translateColorCodes(StringEscapeUtils.unescapeJava(string2));
        String string3 = Bukkit.getPluginManager().isPluginEnabled("PetMaster") ? "&a\u2714" : "&4\u2718";
        this.langVersionCommandPetmaster = this.pluginHeader.toString() + chatColor + this.langConfig.getString("version-command-petmaster") + " " + ChatColor.GRAY + this.translateColorCodes(StringEscapeUtils.unescapeJava(string3));
        boolean bl = Bukkit.getPluginManager().isPluginEnabled("Essentials") && this.mainConfig.getBoolean("IgnoreAFKPlayedTime");
        String string4 = bl ? "&a\u2714" : "&4\u2718";
        this.langVersionCommandEssentials = this.pluginHeader.toString() + chatColor + this.langConfig.getString("version-command-essentials") + " " + ChatColor.GRAY + this.translateColorCodes(StringEscapeUtils.unescapeJava(string4));
        String string5 = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI") ? "&a\u2714" : "&4\u2718";
        this.langVersionCommandPlaceholderAPI = this.pluginHeader.toString() + chatColor + this.langConfig.getString("version-command-placeholderapi") + " " + ChatColor.GRAY + this.translateColorCodes(StringEscapeUtils.unescapeJava(string5));
        String string6 = this.getDatabaseType();
        this.langVersionCommandDatabase = this.pluginHeader.toString() + chatColor + this.langConfig.getString("version-command-database") + " " + ChatColor.GRAY + string6;
    }

    private String getDatabaseType() {
        if ("mysql".equalsIgnoreCase(this.configDatabaseType)) {
            return "MySQL";
        }
        if ("postgresql".equalsIgnoreCase(this.configDatabaseType)) {
            return "PostgreSQL";
        }
        if ("h2".equalsIgnoreCase(this.configDatabaseType)) {
            return "H2";
        }
        return "SQLite";
    }

    @Override
    void onExecute(CommandSender commandSender, String[] stringArray) {
        commandSender.sendMessage(this.header);
        commandSender.sendMessage(this.langVersionCommandDescription);
        commandSender.sendMessage(this.langVersionCommandVersion);
        commandSender.sendMessage(this.langVersionCommandAuthor);
        commandSender.sendMessage(this.langVersionCommandWebsite);
        if (commandSender.hasPermission("achievement.*")) {
            commandSender.sendMessage(this.langVersionCommandVault);
            commandSender.sendMessage(this.langVersionCommandPetmaster);
            commandSender.sendMessage(this.langVersionCommandEssentials);
            commandSender.sendMessage(this.langVersionCommandPlaceholderAPI);
            commandSender.sendMessage(this.langVersionCommandDatabase);
        }
    }
}

