/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.executable;

import com.hm.achievement.command.executable.AbstractCommand;
import com.hm.achievement.command.executable.CommandSpec;
import com.hm.achievement.gui.CategoryGUI;
import com.hm.achievement.gui.GUIItems;
import com.hm.achievement.gui.MainGUI;
import com.hm.achievement.gui.OrderedCategory;
import com.hm.achievement.utils.StringHelper;
import com.hm.apache.commons.lang3.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@Singleton
@CommandSpec(name="list", permission="list", minArgs=1, maxArgs=2)
public class ListCommand
extends AbstractCommand {
    private final MainGUI mainGUI;
    private final CategoryGUI categoryGUI;
    private final GUIItems guiItems;
    private String langCategoryDoesNotExist;

    @Inject
    public ListCommand(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, StringBuilder stringBuilder, MainGUI mainGUI, CategoryGUI categoryGUI, GUIItems gUIItems) {
        super(yamlConfiguration, yamlConfiguration2, stringBuilder);
        this.mainGUI = mainGUI;
        this.categoryGUI = categoryGUI;
        this.guiItems = gUIItems;
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.langCategoryDoesNotExist = this.pluginHeader + this.langConfig.getString("category-does-not-exist");
    }

    @Override
    void onExecute(CommandSender commandSender, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            return;
        }
        Player player = (Player)commandSender;
        if (player.isSleeping()) {
            commandSender.sendMessage(this.langConfig.getString("list-unavailable-whilst-sleeping"));
            return;
        }
        if (stringArray.length == 1) {
            this.mainGUI.displayMainGUI(player);
        } else {
            String string = stringArray[1];
            Optional<Map.Entry> optional = this.guiItems.getOrderedAchievementItems().entrySet().stream().filter(entry -> ((OrderedCategory)entry.getKey()).getCategory().toString().equals(string)).findFirst();
            if (optional.isPresent()) {
                this.categoryGUI.displayCategoryGUI((ItemStack)optional.get().getValue(), player, 0);
            } else {
                List<String> list = this.guiItems.getOrderedAchievementItems().keySet().stream().map(orderedCategory -> orderedCategory.getCategory().toString()).collect(Collectors.toList());
                commandSender.sendMessage(StringUtils.replaceEach(this.langCategoryDoesNotExist, new String[]{"CAT", "CLOSEST_MATCH"}, new String[]{string, StringHelper.getClosestMatch(string, list)}));
            }
        }
    }
}

