/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.executable;

import com.hm.achievement.AdvancedAchievements;
import com.hm.achievement.command.executable.AbstractCommand;
import com.hm.achievement.command.executable.CommandSpec;
import com.hm.achievement.exception.PluginLoadError;
import com.hm.achievement.lifecycle.PluginLoader;
import com.hm.achievement.lifecycle.Reloadable;
import com.hm.dagger.Lazy;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@Singleton
@CommandSpec(name="reload", permission="reload", minArgs=1, maxArgs=1)
public class ReloadCommand
extends AbstractCommand {
    private final AdvancedAchievements advancedAchievements;
    private final Logger logger;
    private final Lazy<PluginLoader> pluginLoader;
    private final Lazy<Set<Reloadable>> reloadables;
    private String langConfigReloadFailed;
    private String langConfigSuccessfullyReloaded;

    @Inject
    public ReloadCommand(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, StringBuilder stringBuilder, AdvancedAchievements advancedAchievements, Logger logger, Lazy<PluginLoader> lazy, Lazy<Set<Reloadable>> lazy2) {
        super(yamlConfiguration, yamlConfiguration2, stringBuilder);
        this.advancedAchievements = advancedAchievements;
        this.logger = logger;
        this.pluginLoader = lazy;
        this.reloadables = lazy2;
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.langConfigReloadFailed = this.pluginHeader + this.langConfig.getString("configuration-reload-failed");
        this.langConfigSuccessfullyReloaded = this.pluginHeader + this.langConfig.getString("configuration-successfully-reloaded");
    }

    public void notifyObservers() {
        for (Reloadable reloadable : this.reloadables.get()) {
            reloadable.extractConfigurationParameters();
        }
    }

    @Override
    void onExecute(CommandSender commandSender, String[] stringArray) {
        try {
            this.pluginLoader.get().loadAdvancedAchievements();
        }
        catch (PluginLoadError pluginLoadError) {
            if (commandSender instanceof Player) {
                commandSender.sendMessage(this.langConfigReloadFailed);
            }
            this.logger.log(Level.SEVERE, "A non recoverable error was encountered while reloading the plugin, disabling it:", pluginLoadError);
            Bukkit.getPluginManager().disablePlugin((Plugin)this.advancedAchievements);
            return;
        }
        if (commandSender instanceof Player) {
            commandSender.sendMessage(this.langConfigSuccessfullyReloaded);
        }
        this.logger.info("Plugin successfully reloaded.");
    }
}

