/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.executable;

import com.hm.achievement.command.executable.AbstractParsableCommand;
import com.hm.achievement.command.executable.CommandSpec;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.utils.StringHelper;
import com.hm.apache.commons.lang3.StringUtils;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

@Singleton
@CommandSpec(name="reset", permission="reset", minArgs=3, maxArgs=3)
public class ResetCommand
extends AbstractParsableCommand {
    public static final String WILDCARD = "*";
    private final CacheManager cacheManager;
    private final AchievementMap achievementMap;
    private String langResetSuccessful;
    private String langResetAllSuccessful;
    private String langCategoryDoesNotExist;

    @Inject
    public ResetCommand(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, StringBuilder stringBuilder, CacheManager cacheManager, AchievementMap achievementMap) {
        super(yamlConfiguration, yamlConfiguration2, stringBuilder);
        this.cacheManager = cacheManager;
        this.achievementMap = achievementMap;
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.langResetSuccessful = this.pluginHeader + this.langConfig.getString("reset-successful");
        this.langResetAllSuccessful = this.pluginHeader + this.langConfig.getString("reset-all-successful");
        this.langCategoryDoesNotExist = this.pluginHeader + this.langConfig.getString("category-does-not-exist");
    }

    @Override
    void onExecuteForPlayer(CommandSender commandSender, String[] stringArray, Player player) {
        String string = stringArray[1];
        Set<String> set = this.achievementMap.getCategorySubcategories();
        if (WILDCARD.equals(string)) {
            this.cacheManager.resetPlayerStatistics(player.getUniqueId(), set);
            commandSender.sendMessage(StringUtils.replace(this.langResetAllSuccessful, "PLAYER", player.getName()));
        } else if (set.contains(string)) {
            this.cacheManager.resetPlayerStatistics(player.getUniqueId(), Collections.singletonList(string));
            commandSender.sendMessage(StringUtils.replaceEach(this.langResetSuccessful, new String[]{"CAT", "PLAYER"}, new String[]{string, player.getName()}));
        } else {
            commandSender.sendMessage(StringUtils.replaceEach(this.langCategoryDoesNotExist, new String[]{"CAT", "CLOSEST_MATCH"}, new String[]{string, StringHelper.getClosestMatch(string, set)}));
        }
    }
}

