/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.executable;

import com.hm.achievement.command.executable.AbstractCommand;
import com.hm.achievement.command.executable.CommandSpec;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.utils.SoundPlayer;
import com.hm.apache.commons.text.StringEscapeUtils;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.ChatColor;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.map.MinecraftFont;

@Singleton
@CommandSpec(name="stats", permission="stats", minArgs=1, maxArgs=1)
public class StatsCommand
extends AbstractCommand {
    private static final MinecraftFont FONT = MinecraftFont.Font;
    private final CacheManager cacheManager;
    private final AchievementMap achievementMap;
    private final SoundPlayer soundPlayer;
    private ChatColor configColor;
    private String configIcon;
    private boolean configAdditionalEffects;
    private boolean configSound;
    private String configSoundStats;
    private String langNumberAchievements;

    @Inject
    public StatsCommand(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, StringBuilder stringBuilder, CacheManager cacheManager, AchievementMap achievementMap, SoundPlayer soundPlayer) {
        super(yamlConfiguration, yamlConfiguration2, stringBuilder);
        this.cacheManager = cacheManager;
        this.achievementMap = achievementMap;
        this.soundPlayer = soundPlayer;
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.configColor = ChatColor.getByChar((String)this.mainConfig.getString("Color"));
        this.configIcon = StringEscapeUtils.unescapeJava(this.mainConfig.getString("Icon"));
        this.configAdditionalEffects = this.mainConfig.getBoolean("AdditionalEffects");
        this.configSound = this.mainConfig.getBoolean("Sound");
        this.configSoundStats = this.mainConfig.getString("SoundStats").toUpperCase();
        this.langNumberAchievements = this.pluginHeader + this.langConfig.getString("number-achievements") + " " + this.configColor;
    }

    @Override
    void onExecute(CommandSender commandSender, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            return;
        }
        Player player = (Player)commandSender;
        int n = this.cacheManager.getPlayerAchievements(player.getUniqueId()).size();
        int n2 = this.achievementMap.getAll().size();
        player.sendMessage(this.langNumberAchievements + String.format("%.1f", 100.0 * (double)n / (double)n2) + "%");
        String string = " " + n + "/" + n2 + " ";
        int n3 = 150 - this.configIcon.length() - FONT.getWidth(string);
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = 1;
        while (n4 < n3) {
            if (!bl && n4 >= n3 / 2) {
                stringBuilder.append(ChatColor.GRAY).append(string);
                bl = true;
                n4 = n3 - n4;
                continue;
            }
            if (n4 < (n3 - 1) * n / n2) {
                stringBuilder.append(this.configColor).append('|');
                ++n4;
                continue;
            }
            stringBuilder.append("&8|");
            ++n4;
        }
        player.sendMessage(this.pluginHeader + "[" + this.translateColorCodes(stringBuilder.toString()) + ChatColor.GRAY + "]");
        if (n >= n2) {
            if (this.configAdditionalEffects) {
                player.spawnParticle(Particle.SPELL_WITCH, player.getLocation(), 400, 0.0, 1.0, 0.0, 0.5);
            }
            if (this.configSound) {
                this.soundPlayer.play(player, this.configSoundStats, "ENTITY_FIREWORK_ROCKET_BLAST");
            }
        }
    }
}

