/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.executor;

import com.hm.achievement.command.executable.AbstractCommand;
import com.hm.achievement.command.executable.CommandSpec;
import com.hm.achievement.lifecycle.Reloadable;
import com.hm.apache.commons.lang3.StringUtils;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;

@Singleton
public class PluginCommandExecutor
implements CommandExecutor,
Reloadable {
    private final YamlConfiguration langConfig;
    private final Set<AbstractCommand> commands;
    private final StringBuilder pluginHeader;
    private String langInvalidCommand;

    @Inject
    public PluginCommandExecutor(@Named(value="lang") YamlConfiguration yamlConfiguration, Set<AbstractCommand> set, StringBuilder stringBuilder) {
        this.langConfig = yamlConfiguration;
        this.commands = set;
        this.pluginHeader = stringBuilder;
    }

    @Override
    public void extractConfigurationParameters() {
        this.langInvalidCommand = this.pluginHeader + this.langConfig.getString("invalid-command");
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        String[] stringArray2 = this.parseArguments(stringArray);
        Optional<AbstractCommand> optional = this.commands.stream().filter(abstractCommand -> this.shouldExecute((AbstractCommand)abstractCommand, stringArray2)).findFirst();
        if (optional.isPresent()) {
            optional.get().execute(commandSender, stringArray2);
        } else {
            commandSender.sendMessage(this.langInvalidCommand);
        }
        return true;
    }

    private String[] parseArguments(String[] stringArray) {
        return (String[])Arrays.stream(stringArray).flatMap(string -> Arrays.stream(StringUtils.split(string, '\u2423'))).toArray(String[]::new);
    }

    private boolean shouldExecute(AbstractCommand abstractCommand, String[] stringArray) {
        CommandSpec commandSpec = abstractCommand.getClass().getAnnotation(CommandSpec.class);
        return stringArray.length >= commandSpec.minArgs() && stringArray.length <= commandSpec.maxArgs() && (stringArray.length == 0 || commandSpec.name().equalsIgnoreCase(stringArray[0]));
    }
}

