/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.command.pagination;

import com.hm.apache.commons.lang3.StringUtils;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;

public class CommandPagination {
    private final List<String> toPaginate;
    private final YamlConfiguration langConfig;
    private final int perPage;
    private final int size;
    private final int maxPage;

    public CommandPagination(List<String> list, int n, YamlConfiguration yamlConfiguration) {
        this.toPaginate = list;
        this.size = list.size();
        this.perPage = n;
        this.langConfig = yamlConfiguration;
        int n2 = this.size % n;
        this.maxPage = (this.size - n2) / n + (n2 > 0 ? 1 : 0);
    }

    public void sendPage(int n, CommandSender commandSender) {
        this.sendPage(n, arg_0 -> ((CommandSender)commandSender).sendMessage(arg_0));
    }

    public void sendPage(int n, Consumer<String> consumer) {
        int n2 = n > this.maxPage ? this.maxPage : n;
        String string = ChatColor.translateAlternateColorCodes((char)'&', (String)StringUtils.replaceEach(this.langConfig.getString("pagination-header"), new String[]{"PAGE", "MAX"}, new String[]{Integer.toString(n2), Integer.toString(this.maxPage)}));
        String string2 = ChatColor.translateAlternateColorCodes((char)'&', (String)this.langConfig.getString("pagination-footer"));
        consumer.accept(string);
        int n3 = n2 - 1;
        int n4 = n3 > 0 ? n3 * this.perPage : 0;
        int n5 = n2 * this.perPage;
        for (int i = n4; i < Math.min(n5, this.size); ++i) {
            consumer.accept(this.toPaginate.get(i));
        }
        consumer.accept(string2);
    }
}

