/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.config;

import com.hm.achievement.category.Category;
import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.domain.Achievement;
import com.hm.achievement.utils.StringHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AchievementMap {
    private final Map<String, Achievement> namesToAchievements = new HashMap<String, Achievement>();
    private final Map<String, Achievement> sanitisedDisplayNamesToAchievements = new HashMap<String, Achievement>();
    private final Map<Category, List<Achievement>> categoriesToAchievements = new HashMap<Category, List<Achievement>>();
    private final Map<String, List<Achievement>> categoriesSubcategoriesToAchievements = new HashMap<String, List<Achievement>>();
    private final Map<Category, Set<String>> categoriesToSubcategories = new HashMap<Category, Set<String>>();

    @Inject
    public AchievementMap() {
    }

    public void put(Achievement achievement) {
        this.namesToAchievements.put(achievement.getName(), achievement);
        this.sanitisedDisplayNamesToAchievements.put(this.sanitise(achievement.getDisplayName()), achievement);
        Category category2 = achievement.getCategory();
        this.categoriesToAchievements.computeIfAbsent(category2, category -> new ArrayList()).add(achievement);
        this.categoriesToSubcategories.computeIfAbsent(category2, category -> new HashSet()).add(achievement.getSubcategory());
        if (category2 instanceof NormalAchievements) {
            this.categoriesSubcategoriesToAchievements.computeIfAbsent(category2.toString(), string -> new ArrayList()).add(achievement);
        } else if (category2 instanceof MultipleAchievements) {
            this.categoriesSubcategoriesToAchievements.computeIfAbsent(category2 + "." + achievement.getSubcategory(), string -> new ArrayList()).add(achievement);
        }
    }

    public Collection<Achievement> getAll() {
        return this.namesToAchievements.values();
    }

    public Collection<String> getAllNames() {
        return this.namesToAchievements.keySet();
    }

    public Collection<String> getAllSanitisedDisplayNames() {
        return this.sanitisedDisplayNamesToAchievements.keySet();
    }

    public void clearAll() {
        this.namesToAchievements.clear();
        this.sanitisedDisplayNamesToAchievements.clear();
        this.categoriesToAchievements.clear();
        this.categoriesSubcategoriesToAchievements.clear();
        this.categoriesToSubcategories.clear();
    }

    public Achievement getForName(String string) {
        return this.namesToAchievements.get(string);
    }

    public Achievement getForDisplayName(String string) {
        return this.sanitisedDisplayNamesToAchievements.get(this.sanitise(string));
    }

    public List<Achievement> getForCategory(Category category) {
        return this.categoriesToAchievements.getOrDefault(category, Collections.emptyList());
    }

    public List<Achievement> getForCategoryAndSubcategory(Category category, String string) {
        return this.categoriesSubcategoriesToAchievements.get(category + "." + string);
    }

    public Set<String> getSubcategoriesForCategory(Category category) {
        return this.categoriesToSubcategories.getOrDefault(category, Collections.emptySet());
    }

    public Set<String> getCategorySubcategories() {
        return this.categoriesSubcategoriesToAchievements.keySet();
    }

    private String sanitise(String string) {
        return StringHelper.removeFormattingCodes(string).toLowerCase();
    }
}

