/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.config;

import com.hm.achievement.AdvancedAchievements;
import com.hm.achievement.category.Category;
import com.hm.achievement.category.CommandAchievements;
import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.config.RewardParser;
import com.hm.achievement.config.YamlUpdater;
import com.hm.achievement.domain.Achievement;
import com.hm.achievement.exception.PluginLoadError;
import com.hm.achievement.utils.StringHelper;
import com.hm.apache.commons.lang3.StringUtils;
import com.hm.apache.commons.text.StringEscapeUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigurationParser {
    private final YamlConfiguration mainConfig;
    private final YamlConfiguration langConfig;
    private final YamlConfiguration guiConfig;
    private final AchievementMap achievementMap;
    private final Set<Category> disabledCategories;
    private final StringBuilder pluginHeader;
    private final Logger logger;
    private final int serverVersion;
    private final YamlUpdater yamlUpdater;
    private final AdvancedAchievements plugin;
    private final RewardParser rewardParser;

    @Inject
    public ConfigurationParser(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, @Named(value="gui") YamlConfiguration yamlConfiguration3, AchievementMap achievementMap, Set<Category> set, StringBuilder stringBuilder, Logger logger, int n, YamlUpdater yamlUpdater, AdvancedAchievements advancedAchievements, RewardParser rewardParser) {
        this.mainConfig = yamlConfiguration;
        this.langConfig = yamlConfiguration2;
        this.guiConfig = yamlConfiguration3;
        this.achievementMap = achievementMap;
        this.disabledCategories = set;
        this.pluginHeader = stringBuilder;
        this.logger = logger;
        this.serverVersion = n;
        this.yamlUpdater = yamlUpdater;
        this.plugin = advancedAchievements;
        this.rewardParser = rewardParser;
    }

    public void loadAndParseConfiguration() {
        this.logger.info("Backing up and loading configuration files...");
        this.backupAndLoadConfiguration("config.yml", "config.yml", this.mainConfig);
        this.backupAndLoadConfiguration("lang.yml", this.mainConfig.getString("LanguageFileName"), this.langConfig);
        this.backupAndLoadConfiguration("gui.yml", "gui.yml", this.guiConfig);
        this.parseHeader();
        this.parseDisabledCategories();
        this.parseAchievements();
        this.logLoadingMessages();
    }

    private Set<String> getSectionKeys(String string) {
        return this.mainConfig.isConfigurationSection(string) ? this.mainConfig.getConfigurationSection(string).getKeys(false) : Collections.emptySet();
    }

    private void backupAndLoadConfiguration(String string, String string2, YamlConfiguration yamlConfiguration) {
        Object object;
        File file = new File(this.plugin.getDataFolder(), string2);
        try {
            object = new File(this.plugin.getDataFolder(), string2 + ".bak");
            if (file.lastModified() > ((File)object).lastModified()) {
                Files.copy(file.toPath(), ((File)object).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException iOException) {
            this.logger.log(Level.SEVERE, "Failed to back up " + string2 + ":", iOException);
        }
        try {
            if (!file.exists()) {
                file.getParentFile().mkdir();
                object = this.plugin.getResource(string2);
                try {
                    Files.copy((InputStream)object, file.toPath(), new CopyOption[0]);
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
            }
            yamlConfiguration.load(file);
            this.yamlUpdater.update(string, string2, yamlConfiguration);
        }
        catch (IOException | InvalidConfigurationException throwable) {
            throw new PluginLoadError("Failed to load " + string2 + ". Verify its syntax on yaml-online-parser.appspot.com and use the following logs.", (Exception)throwable);
        }
    }

    private void parseHeader() {
        this.pluginHeader.setLength(0);
        String string = StringEscapeUtils.unescapeJava(this.mainConfig.getString("Icon"));
        if (StringUtils.isNotBlank(string)) {
            String string2 = ChatColor.getByChar((String)this.mainConfig.getString("Color")) + string;
            this.pluginHeader.append(ChatColor.translateAlternateColorCodes((char)'&', (String)StringUtils.replace(this.mainConfig.getString("ChatHeader"), "%ICON%", string2))).append(" ");
        }
        this.pluginHeader.trimToSize();
    }

    private void parseDisabledCategories() {
        this.extractDisabledCategoriesFromConfig();
        if (!(this.disabledCategories.contains(NormalAchievements.PETMASTERGIVE) && this.disabledCategories.contains(NormalAchievements.PETMASTERRECEIVE) || Bukkit.getPluginManager().isPluginEnabled("PetMaster"))) {
            this.disabledCategories.add(NormalAchievements.PETMASTERGIVE);
            this.disabledCategories.add(NormalAchievements.PETMASTERRECEIVE);
            this.logger.warning("Overriding configuration: disabling PetMasterGive and PetMasterReceive categories.");
            this.logger.warning("Ensure you have placed Pet Master in your plugins folder or add PetMasterGive and PetMasterReceive to the DisabledCategories list in config.yml.");
        }
        if (!this.disabledCategories.contains(MultipleAchievements.JOBSREBORN) && !Bukkit.getPluginManager().isPluginEnabled("Jobs")) {
            this.disabledCategories.add(MultipleAchievements.JOBSREBORN);
            this.logger.warning("Overriding configuration: disabling JobsReborn category.");
            this.logger.warning("Ensure you have placed JobsReborn in your plugins folder or add JobsReborn to the DisabledCategories list in config.yml.");
        }
        if (!this.disabledCategories.contains(NormalAchievements.RAIDSWON) && this.serverVersion < 14) {
            this.disabledCategories.add(NormalAchievements.RAIDSWON);
            this.logger.warning("Overriding configuration: disabling RaidsWon category.");
            this.logger.warning("Raids are not available in your server version, please add RaidsWon to the DisabledCategories list in config.yml.");
        }
    }

    private void extractDisabledCategoriesFromConfig() {
        this.disabledCategories.clear();
        for (String string : this.mainConfig.getStringList("DisabledCategories")) {
            Category category;
            CommandAchievements commandAchievements = category = CommandAchievements.COMMANDS.toString().equals(string) ? CommandAchievements.COMMANDS : null;
            if (category == null) {
                category = NormalAchievements.getByName(string);
            }
            if (category == null) {
                category = MultipleAchievements.getByName(string);
            }
            if (category == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                Arrays.stream(NormalAchievements.values()).forEach(normalAchievements -> arrayList.add(normalAchievements.toString()));
                Arrays.stream(MultipleAchievements.values()).forEach(multipleAchievements -> arrayList.add(multipleAchievements.toString()));
                arrayList.add(CommandAchievements.COMMANDS.toString());
                throw new PluginLoadError("Category " + string + " specified in DisabledCategories is misspelt. Did you mean " + StringHelper.getClosestMatch(string, arrayList) + "?");
            }
            this.disabledCategories.add(category);
        }
    }

    private void parseAchievements() {
        Set<String> set;
        this.achievementMap.clearAll();
        if (!this.disabledCategories.contains(CommandAchievements.COMMANDS)) {
            Set<String> set2 = this.getSectionKeys(CommandAchievements.COMMANDS.toString());
            if (set2.isEmpty()) {
                this.disabledCategories.add(CommandAchievements.COMMANDS);
            } else {
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.parseAchievement(CommandAchievements.COMMANDS, string, -1L);
                }
            }
        }
        for (NormalAchievements object : NormalAchievements.values()) {
            if (this.disabledCategories.contains(object)) continue;
            if (this.getSectionKeys(object.toString()).isEmpty()) {
                this.disabledCategories.add(object);
                continue;
            }
            set = this.getSortedThresholds(object.toString()).iterator();
            while (set.hasNext()) {
                long l = (Long)set.next();
                this.parseAchievement(object, "", l);
            }
        }
        for (MultipleAchievements multipleAchievements : MultipleAchievements.values()) {
            if (this.disabledCategories.contains(multipleAchievements)) continue;
            set = this.getSectionKeys(multipleAchievements.toString());
            if (set.isEmpty()) {
                this.disabledCategories.add(multipleAchievements);
                continue;
            }
            for (String string : set) {
                for (long l : this.getSortedThresholds(multipleAchievements + "." + string)) {
                    this.parseAchievement(multipleAchievements, string, l);
                }
            }
        }
    }

    private List<Long> getSortedThresholds(String string) {
        return this.mainConfig.getConfigurationSection(string).getKeys(false).stream().map(Long::parseLong).sorted().collect(Collectors.toList());
    }

    private void parseAchievement(Category category, String string, long l) {
        String string2 = category instanceof CommandAchievements ? category + "." + string : (category instanceof NormalAchievements ? category + "." + l : category + "." + string + "." + l);
        ConfigurationSection configurationSection = this.mainConfig.getConfigurationSection(string2);
        if (!configurationSection.contains("Name")) {
            throw new PluginLoadError("Achievement with path (" + string2 + ") is missing its Name parameter in config.yml.");
        }
        if (this.achievementMap.getForName(configurationSection.getString("Name")) != null) {
            throw new PluginLoadError("Duplicate achievement Name (" + configurationSection.getString("Name") + "). Please ensure each Name is unique in config.yml.");
        }
        if (!configurationSection.contains("Message")) {
            throw new PluginLoadError("Achievement with path (" + string2 + ") is missing its Message parameter in config.yml.");
        }
        String string3 = this.mainConfig.isConfigurationSection(string2 + ".Reward") ? string2 + ".Reward" : string2 + ".Rewards";
        Achievement achievement = new Achievement.AchievementBuilder().name(configurationSection.getString("Name")).displayName(StringUtils.defaultString(configurationSection.getString("DisplayName"), configurationSection.getString("Name"))).message(configurationSection.getString("Message")).goal(StringUtils.defaultString(configurationSection.getString("Goal"), configurationSection.getString("Message"))).type(configurationSection.getString("Type")).threshold(l).category(category).subcategory(string).rewards(this.rewardParser.parseRewards(string3)).build();
        this.achievementMap.put(achievement);
    }

    private void logLoadingMessages() {
        int n = this.disabledCategories.size();
        int n2 = NormalAchievements.values().length + MultipleAchievements.values().length + 1 - n;
        this.logger.info("Loaded " + this.achievementMap.getAll().size() + " achievements in " + n2 + " categories.");
        if (!this.disabledCategories.isEmpty()) {
            String string = n == 1 ? "category" : "categories";
            this.logger.info(n + " disabled " + string + ": " + this.disabledCategories.toString());
        }
    }
}

