/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.db;

import com.hm.achievement.db.AbstractDatabaseManager;
import com.hm.achievement.db.DatabaseUpdater;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import javax.inject.Named;
import org.bukkit.configuration.file.YamlConfiguration;

public class AbstractRemoteDatabaseManager
extends AbstractDatabaseManager {
    volatile String databaseAddress;
    volatile String databaseUser;
    volatile String databasePassword;
    volatile String additionalConnectionOptions;
    private final String databaseType;

    public AbstractRemoteDatabaseManager(@Named(value="main") YamlConfiguration yamlConfiguration, Logger logger, DatabaseUpdater databaseUpdater, String string, String string2, ExecutorService executorService) {
        super(yamlConfiguration, logger, databaseUpdater, string, executorService);
        this.databaseType = string2;
    }

    @Override
    void performPreliminaryTasks() {
        Class.forName(this.driverPath);
        this.databaseAddress = this.getDatabaseAddress();
        this.databaseUser = URLEncoder.encode(this.mainConfig.getString("DatabaseUser"), StandardCharsets.UTF_8.name());
        this.databasePassword = URLEncoder.encode(this.mainConfig.getString("DatabasePassword"), StandardCharsets.UTF_8.name());
        this.additionalConnectionOptions = this.mainConfig.getString("AdditionalConnectionOptions");
    }

    @Override
    Connection createConnection() {
        return DriverManager.getConnection(this.databaseAddress + "?autoReconnect=true" + this.additionalConnectionOptions + "&user=" + this.databaseUser + "&password=" + this.databasePassword);
    }

    private String getDatabaseAddress() {
        String string = this.mainConfig.getString("DatabaseAddress");
        if (!string.startsWith("jdbc:")) {
            if (string.startsWith(this.databaseType + "://")) {
                return "jdbc:" + string;
            }
            return "jdbc:" + this.databaseType + "://" + string;
        }
        return string;
    }
}

