/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.db;

import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.db.AbstractDatabaseManager;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.db.CachedStatistic;
import com.hm.achievement.db.PostgreSQLDatabaseManager;
import com.hm.achievement.db.SQLWriteOperation;
import com.hm.achievement.db.SubcategoryUUID;
import com.hm.apache.commons.lang3.StringUtils;
import java.sql.BatchUpdateException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.inject.Inject;

public class AsyncCachedRequestsSender
implements Runnable {
    private final Logger logger;
    private final CacheManager cacheManager;
    private final AbstractDatabaseManager databaseManager;

    @Inject
    public AsyncCachedRequestsSender(Logger logger, CacheManager cacheManager, AbstractDatabaseManager abstractDatabaseManager) {
        this.logger = logger;
        this.cacheManager = cacheManager;
        this.databaseManager = abstractDatabaseManager;
    }

    @Override
    public void run() {
        this.sendBatchedRequests();
        this.cacheManager.cleanStaleCaches();
    }

    public void sendBatchedRequests() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MultipleAchievements enum_ : MultipleAchievements.values()) {
            this.addRequestsForMultipleCategory(arrayList, enum_);
        }
        for (Enum enum_ : NormalAchievements.values()) {
            this.addRequestsForNormalCategory(arrayList, (NormalAchievements)enum_);
        }
        if (!arrayList.isEmpty()) {
            ((SQLWriteOperation)() -> {
                try (Statement statement = this.databaseManager.getConnection().createStatement();){
                    for (String string : arrayList) {
                        statement.addBatch(string);
                    }
                    statement.executeBatch();
                }
                catch (BatchUpdateException batchUpdateException) {
                    this.databaseManager.getConnection().close();
                    throw batchUpdateException;
                }
            }).attemptWrites(this.logger, "batching statistic updates");
        }
    }

    private void addRequestsForMultipleCategory(List<String> list, MultipleAchievements multipleAchievements) {
        Map<SubcategoryUUID, CachedStatistic> map = this.cacheManager.getHashMap(multipleAchievements);
        for (Map.Entry<SubcategoryUUID, CachedStatistic> entry : map.entrySet()) {
            CachedStatistic cachedStatistic = entry.getValue();
            if (cachedStatistic.isDatabaseConsistent()) continue;
            cachedStatistic.prepareDatabaseWrite();
            UUID uUID = entry.getKey().getUUID();
            String string = StringUtils.replace(entry.getKey().getSubcategory(), "'", "''");
            if (this.databaseManager instanceof PostgreSQLDatabaseManager) {
                list.add("INSERT INTO " + this.databaseManager.getPrefix() + multipleAchievements.toDBName() + " VALUES ('" + uUID + "', '" + string + "', " + cachedStatistic.getValue() + ") ON CONFLICT (playername, " + multipleAchievements.toSubcategoryDBName() + ") DO UPDATE SET (" + multipleAchievements.toDBName() + ")=(" + cachedStatistic.getValue() + ")");
                continue;
            }
            list.add("REPLACE INTO " + this.databaseManager.getPrefix() + multipleAchievements.toDBName() + " VALUES ('" + uUID + "', '" + string + "', " + cachedStatistic.getValue() + ")");
        }
    }

    private void addRequestsForNormalCategory(List<String> list, NormalAchievements normalAchievements) {
        Map<UUID, CachedStatistic> map = this.cacheManager.getHashMap(normalAchievements);
        for (Map.Entry<UUID, CachedStatistic> entry : map.entrySet()) {
            CachedStatistic cachedStatistic = entry.getValue();
            if (cachedStatistic.isDatabaseConsistent()) continue;
            cachedStatistic.prepareDatabaseWrite();
            UUID uUID = entry.getKey();
            if (this.databaseManager instanceof PostgreSQLDatabaseManager) {
                list.add("INSERT INTO " + this.databaseManager.getPrefix() + normalAchievements.toDBName() + " VALUES ('" + uUID + "', " + cachedStatistic.getValue() + ") ON CONFLICT (playername) DO UPDATE SET (" + normalAchievements.toDBName() + ")=(" + cachedStatistic.getValue() + ")");
                continue;
            }
            list.add("REPLACE INTO " + this.databaseManager.getPrefix() + normalAchievements.toDBName() + " VALUES ('" + uUID + "', " + cachedStatistic.getValue() + ")");
        }
    }
}

