/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.db;

import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.db.AbstractDatabaseManager;
import com.hm.achievement.db.MySQLDatabaseManager;
import com.hm.achievement.db.SQLiteDatabaseManager;
import com.hm.achievement.exception.PluginLoadError;
import com.hm.apache.commons.lang3.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatabaseUpdater {
    private final Logger logger;

    @Inject
    DatabaseUpdater(Logger logger) {
        this.logger = logger;
    }

    void renameExistingTables(AbstractDatabaseManager abstractDatabaseManager) {
        block17: {
            if (StringUtils.isNotBlank(abstractDatabaseManager.getPrefix())) {
                try (ResultSet resultSet = abstractDatabaseManager.getConnection().getMetaData().getTables(null, null, "achievements", null);){
                    if (!resultSet.next()) break block17;
                    this.logger.info("Adding " + abstractDatabaseManager.getPrefix() + " prefix to database table names, please wait...");
                    try (Statement statement = abstractDatabaseManager.getConnection().createStatement();){
                        statement.addBatch("ALTER TABLE achievements RENAME TO " + abstractDatabaseManager.getPrefix() + "achievements");
                        for (NormalAchievements enum_ : NormalAchievements.values()) {
                            statement.addBatch("ALTER TABLE " + enum_.toDBName() + " RENAME TO " + abstractDatabaseManager.getPrefix() + enum_.toDBName());
                        }
                        for (Enum enum_ : MultipleAchievements.values()) {
                            statement.addBatch("ALTER TABLE " + ((MultipleAchievements)enum_).toDBName() + " RENAME TO " + abstractDatabaseManager.getPrefix() + ((MultipleAchievements)enum_).toDBName());
                        }
                        statement.executeBatch();
                    }
                }
                catch (SQLException sQLException) {
                    throw new PluginLoadError("Error while setting prefix of database tables.", sQLException);
                }
            }
        }
    }

    void initialiseTables(AbstractDatabaseManager abstractDatabaseManager, int n) {
        try (Statement statement = abstractDatabaseManager.getConnection().createStatement();){
            statement.addBatch("CREATE TABLE IF NOT EXISTS " + abstractDatabaseManager.getPrefix() + "achievements (playername char(36),achievement varchar(64),date TIMESTAMP,PRIMARY KEY (playername, achievement))");
            for (MultipleAchievements enum_ : MultipleAchievements.values()) {
                statement.addBatch("CREATE TABLE IF NOT EXISTS " + abstractDatabaseManager.getPrefix() + enum_.toDBName() + " (playername char(36)," + enum_.toSubcategoryDBName() + " varchar(" + n + ")," + enum_.toDBName() + " INT,PRIMARY KEY(playername, " + enum_.toSubcategoryDBName() + "))");
            }
            for (Enum enum_ : NormalAchievements.values()) {
                if (enum_ == NormalAchievements.CONNECTIONS) {
                    statement.addBatch("CREATE TABLE IF NOT EXISTS " + abstractDatabaseManager.getPrefix() + ((NormalAchievements)enum_).toDBName() + " (playername char(36)," + ((NormalAchievements)enum_).toDBName() + " INT,date varchar(10),PRIMARY KEY (playername))");
                    continue;
                }
                statement.addBatch("CREATE TABLE IF NOT EXISTS " + abstractDatabaseManager.getPrefix() + ((NormalAchievements)enum_).toDBName() + " (playername char(36)," + ((NormalAchievements)enum_).toDBName() + " BIGINT,PRIMARY KEY (playername))");
            }
            statement.executeBatch();
        }
        catch (SQLException sQLException) {
            throw new PluginLoadError("Error while initialising database tables.", sQLException);
        }
    }

    void updateOldDBColumnSize(AbstractDatabaseManager abstractDatabaseManager, MultipleAchievements multipleAchievements, int n) {
        if (!(abstractDatabaseManager instanceof SQLiteDatabaseManager)) {
            try (Statement statement = abstractDatabaseManager.getConnection().createStatement();
                 ResultSet resultSet = statement.executeQuery("SELECT " + multipleAchievements.toSubcategoryDBName() + " FROM " + abstractDatabaseManager.getPrefix() + multipleAchievements.toDBName() + " LIMIT 1");){
                if (resultSet.getMetaData().getPrecision(1) < n) {
                    this.logger.info("Changing " + multipleAchievements.toDBName() + " database column size to " + n + ", please wait...");
                    String string = abstractDatabaseManager instanceof MySQLDatabaseManager ? "MODIFY " + multipleAchievements.toSubcategoryDBName() + " varchar(" + n + ")" : "ALTER COLUMN " + multipleAchievements.toSubcategoryDBName() + " TYPE varchar(" + n + ")";
                    statement.execute("ALTER TABLE " + abstractDatabaseManager.getPrefix() + multipleAchievements.toDBName() + " " + string);
                }
            }
            catch (SQLException sQLException) {
                this.logger.log(Level.SEVERE, "Database error while updating old " + multipleAchievements.toDBName() + " table:", sQLException);
            }
        }
    }
}

