/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.db;

import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.db.AbstractRemoteDatabaseManager;
import com.hm.achievement.db.DatabaseUpdater;
import com.hm.achievement.db.SQLWriteOperation;
import com.hm.achievement.db.data.ConnectionInformation;
import com.hm.postgresql.Driver;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import javax.inject.Named;
import org.bukkit.configuration.file.YamlConfiguration;

public class PostgreSQLDatabaseManager
extends AbstractRemoteDatabaseManager {
    public PostgreSQLDatabaseManager(@Named(value="main") YamlConfiguration yamlConfiguration, Logger logger, DatabaseUpdater databaseUpdater, ExecutorService executorService) {
        super(yamlConfiguration, logger, databaseUpdater, "com.hm.postgresql.Driver", "postgresql", executorService);
    }

    @Override
    void performPreliminaryTasks() {
        super.performPreliminaryTasks();
        Class[] classArray = new Class[]{Driver.class};
    }

    @Override
    public void registerAchievement(UUID uUID, String string, long l) {
        ((SQLWriteOperation)() -> {
            String string2 = "INSERT INTO " + this.prefix + "achievements VALUES (?,?,?) ON CONFLICT (playername,achievement) DO UPDATE SET (date)=(?)";
            try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(string2);){
                preparedStatement.setString(1, uUID.toString());
                preparedStatement.setString(2, string);
                preparedStatement.setTimestamp(3, new Timestamp(l));
                preparedStatement.setTimestamp(4, new Timestamp(l));
                preparedStatement.execute();
            }
        }).executeOperation(this.writeExecutor, this.logger, "registering an achievement");
    }

    @Override
    public void updateConnectionInformation(UUID uUID, long l) {
        ((SQLWriteOperation)() -> {
            String string = "INSERT INTO " + this.prefix + NormalAchievements.CONNECTIONS.toDBName() + " VALUES (?,?,?) ON CONFLICT (playername) DO UPDATE SET (" + NormalAchievements.CONNECTIONS.toDBName() + ",date)=(?,?)";
            try (PreparedStatement preparedStatement = this.getConnection().prepareStatement(string);){
                String string2 = ConnectionInformation.today();
                preparedStatement.setString(1, uUID.toString());
                preparedStatement.setLong(2, l);
                preparedStatement.setString(3, string2);
                preparedStatement.setLong(4, l);
                preparedStatement.setString(5, string2);
                preparedStatement.execute();
            }
        }).executeOperation(this.writeExecutor, this.logger, "updating connection date and count");
    }
}

