/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.db;

import java.sql.SQLException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

@FunctionalInterface
public interface SQLWriteOperation {
    public static final int MAX_ATTEMPTS = 5;

    public void performWrite() throws SQLException;

    default public void executeOperation(Executor executor, Logger logger, String operationMessage) {
        executor.execute(() -> this.attemptWrites(logger, operationMessage));
    }

    default public void attemptWrites(Logger logger, String operationMessage) {
        for (int attempt = 1; attempt <= 5; ++attempt) {
            try {
                this.performWrite();
                return;
            }
            catch (SQLException e) {
                if (attempt == 5) {
                    logger.log(Level.SEVERE, "Database write error while " + operationMessage + ":", e);
                    continue;
                }
                this.sleepOneSecond(logger);
                continue;
            }
        }
    }

    default public void sleepOneSecond(Logger logger) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "Thead interrupted while sleeping:", e);
            Thread.currentThread().interrupt();
        }
    }
}

