/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.domain;

import com.hm.achievement.category.Category;
import com.hm.achievement.domain.Reward;
import java.util.Collections;
import java.util.List;

public class Achievement {
    private final Category category;
    private final String subcategory;
    private final long threshold;
    private final String name;
    private final String displayName;
    private final String message;
    private final String goal;
    private final String type;
    private final List<Reward> rewards;

    private Achievement(Category category, String string, long l, String string2, String string3, String string4, String string5, String string6, List<Reward> list) {
        this.category = category;
        this.subcategory = string;
        this.threshold = l;
        this.name = string2;
        this.displayName = string3;
        this.message = string4;
        this.goal = string5;
        this.type = string6;
        this.rewards = list;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getSubcategory() {
        return this.subcategory;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getMessage() {
        return this.message;
    }

    public String getGoal() {
        return this.goal;
    }

    public String getType() {
        return this.type;
    }

    public List<Reward> getRewards() {
        return this.rewards;
    }

    public static class AchievementBuilder {
        private Category category;
        private String subcategory;
        private long threshold;
        private String name;
        private String displayName;
        private String message;
        private String goal;
        private String type;
        private List<Reward> rewards = Collections.emptyList();

        public AchievementBuilder category(Category category) {
            this.category = category;
            return this;
        }

        public AchievementBuilder subcategory(String string) {
            this.subcategory = string;
            return this;
        }

        public AchievementBuilder threshold(long l) {
            this.threshold = l;
            return this;
        }

        public AchievementBuilder name(String string) {
            this.name = string;
            return this;
        }

        public AchievementBuilder displayName(String string) {
            this.displayName = string;
            return this;
        }

        public AchievementBuilder message(String string) {
            this.message = string;
            return this;
        }

        public AchievementBuilder goal(String string) {
            this.goal = string;
            return this;
        }

        public AchievementBuilder type(String string) {
            this.type = string;
            return this;
        }

        public AchievementBuilder rewards(List<Reward> list) {
            this.rewards = list;
            return this;
        }

        public Achievement build() {
            return new Achievement(this.category, this.subcategory, this.threshold, this.name, this.displayName, this.message, this.goal, this.type, this.rewards);
        }
    }
}

