/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.gui;

import com.hm.achievement.category.Category;
import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.AbstractDatabaseManager;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.domain.Achievement;
import com.hm.achievement.domain.Reward;
import com.hm.achievement.gui.AchievementInventoryHolder;
import com.hm.achievement.gui.GUIItems;
import com.hm.achievement.gui.OrderedCategory;
import com.hm.achievement.lifecycle.Reloadable;
import com.hm.achievement.utils.NumberHelper;
import com.hm.achievement.utils.StringHelper;
import com.hm.apache.commons.lang3.RandomStringUtils;
import com.hm.apache.commons.lang3.StringUtils;
import com.hm.apache.commons.text.StringEscapeUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Singleton
public class CategoryGUI
implements Reloadable {
    public static final int ROW_SIZE = 9;
    private static final int MAX_ACHIEVEMENTS_PER_PAGE = 45;
    private static final long NO_STAT = -1L;
    private static final String NO_SUBCATEGORY = "";
    private static final int PROGRESS_BAR_SIZE = 90;
    private static final DecimalFormat TIME_FORMAT = new DecimalFormat("0");
    private final YamlConfiguration mainConfig;
    private final YamlConfiguration langConfig;
    private final CacheManager cacheManager;
    private final AbstractDatabaseManager databaseManager;
    private final GUIItems guiItems;
    private final AchievementMap achievementMap;
    private boolean configObfuscateNotReceived;
    private boolean configObfuscateProgressiveAchievements;
    private boolean configHideProgressiveAchievements;
    private boolean configHideRewardDisplayInList;
    private boolean configEnrichedProgressBars;
    private boolean configNumberedItemsInList;
    private ChatColor configColor;
    private ChatColor configListColorNotReceived;
    private String configFormatNotReceived;
    private boolean configBackButtonIsCategoryItem;
    private String langListBackMessage;
    private String langListBackLore;
    private String langListGUITitle;
    private String langListAchievementReceived;
    private String langListAchievementNotReceived;
    private String langListDescription;
    private String langListReception;
    private String langListGoal;
    private String langListProgress;
    private String langListReward;
    private String langListRewards;

    @Inject
    public CategoryGUI(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, CacheManager cacheManager, AbstractDatabaseManager abstractDatabaseManager, GUIItems gUIItems, AchievementMap achievementMap) {
        this.mainConfig = yamlConfiguration;
        this.langConfig = yamlConfiguration2;
        this.cacheManager = cacheManager;
        this.databaseManager = abstractDatabaseManager;
        this.guiItems = gUIItems;
        this.achievementMap = achievementMap;
    }

    @Override
    public void extractConfigurationParameters() {
        this.configObfuscateNotReceived = this.mainConfig.getBoolean("ObfuscateNotReceived");
        this.configObfuscateProgressiveAchievements = this.mainConfig.getBoolean("ObfuscateProgressiveAchievements");
        this.configHideProgressiveAchievements = this.mainConfig.getBoolean("HideProgressiveAchievements");
        this.configHideRewardDisplayInList = this.mainConfig.getBoolean("HideRewardDisplayInList");
        this.configEnrichedProgressBars = this.mainConfig.getBoolean("EnrichedListProgressBars");
        this.configNumberedItemsInList = this.mainConfig.getBoolean("NumberedItemsInList");
        this.configColor = ChatColor.getByChar((String)this.mainConfig.getString("Color"));
        this.configListColorNotReceived = ChatColor.getByChar((String)this.mainConfig.getString("ListColorNotReceived"));
        this.configFormatNotReceived = this.mainConfig.getBoolean("ListItaliciseNotReceived") ? "&o" : NO_SUBCATEGORY;
        this.configBackButtonIsCategoryItem = this.mainConfig.getBoolean("BackButtonIsCategoryItem");
        this.langListBackMessage = this.translateColorCodes(this.langConfig.getString("list-back-message"));
        this.langListBackLore = this.translateColorCodes(this.langConfig.getString("list-back-lore"));
        this.langListGUITitle = this.translateColorCodes(this.langConfig.getString("list-gui-title"));
        this.langListAchievementReceived = StringEscapeUtils.unescapeJava(this.langConfig.getString("list-achievement-received"));
        this.langListAchievementNotReceived = StringEscapeUtils.unescapeJava(this.langConfig.getString("list-achievement-not-received")) + this.configListColorNotReceived;
        String string = this.langConfig.getString("list-description");
        this.langListDescription = string.isEmpty() ? NO_SUBCATEGORY : this.translateColorCodes("&7&l" + string);
        String string2 = this.langConfig.getString("list-reception");
        this.langListReception = string2.isEmpty() ? NO_SUBCATEGORY : this.translateColorCodes("&7&l" + string2);
        String string3 = this.langConfig.getString("list-goal");
        this.langListGoal = string3.isEmpty() ? NO_SUBCATEGORY : this.translateColorCodes("&7&l" + string3);
        String string4 = this.langConfig.getString("list-progress");
        this.langListProgress = string4.isEmpty() ? NO_SUBCATEGORY : this.translateColorCodes("&7&l" + string4);
        String string5 = this.langConfig.getString("list-reward");
        this.langListReward = string5.isEmpty() ? NO_SUBCATEGORY : this.translateColorCodes("&7&l" + string5);
        String string6 = this.langConfig.getString("list-rewards");
        this.langListRewards = string6.isEmpty() ? NO_SUBCATEGORY : this.translateColorCodes("&7&l" + string6);
    }

    public void displayCategoryGUI(ItemStack itemStack, Player player, int n) {
        for (Map.Entry<OrderedCategory, ItemStack> entry : this.guiItems.getOrderedAchievementItems().entrySet()) {
            Map<String, Long> map;
            if (!entry.getValue().getItemMeta().getDisplayName().equals(itemStack.getItemMeta().getDisplayName())) continue;
            Category category = entry.getKey().getCategory();
            List<Achievement> list = this.achievementMap.getForCategory(category);
            if (category instanceof MultipleAchievements) {
                map = this.getMultipleStatisticsMapping((MultipleAchievements)category, player);
            } else if (category instanceof NormalAchievements) {
                long l = this.getNormalStatistic((NormalAchievements)category, player);
                map = Collections.singletonMap(NO_SUBCATEGORY, l);
            } else {
                map = list.stream().collect(Collectors.toMap(Achievement::getSubcategory, achievement -> -1L));
            }
            this.displayPage(player, map, n, itemStack, list);
            return;
        }
    }

    private void displayPage(Player player, Map<String, Long> map, int n, ItemStack itemStack, List<Achievement> list) {
        Object object;
        int n2 = this.getPageIndex(n, list.size());
        int n3 = 45 * n2;
        int n4 = Math.min(45 * (n2 + 1), list.size());
        int n5 = Math.min(NumberHelper.nextMultipleOf9(list.size()), 45) + 9;
        AchievementInventoryHolder achievementInventoryHolder = new AchievementInventoryHolder(n2, itemStack);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)achievementInventoryHolder, (int)n5, (String)this.langListGUITitle);
        achievementInventoryHolder.setInventory(inventory);
        String string = null;
        String string2 = NO_SUBCATEGORY;
        int n6 = 0;
        if (n3 > 0) {
            Achievement achievement = list.get(n3 - 1);
            string = this.databaseManager.getPlayerAchievementDate(player.getUniqueId(), achievement.getName());
            string2 = achievement.getSubcategory();
            object = list.get(n3).getSubcategory();
            if (!((String)object).isEmpty()) {
                n6 = IntStream.range(0, list.size()).filter(arg_0 -> CategoryGUI.lambda$displayPage$1(list, (String)object, arg_0)).findFirst().getAsInt();
            }
        }
        for (int i = n3; i < n4; ++i) {
            boolean bl;
            object = list.get(i);
            long l = map.get(((Achievement)object).getSubcategory());
            String string3 = this.databaseManager.getPlayerAchievementDate(player.getUniqueId(), ((Achievement)object).getName());
            boolean bl2 = bl = !string2.equals(((Achievement)object).getSubcategory());
            if (bl) {
                n6 = i;
            }
            boolean bl3 = true;
            if (l == -1L || string3 != null || string != null || i == n3 && n3 == 0 || bl) {
                bl3 = false;
            }
            if (this.configHideProgressiveAchievements && bl3) {
                inventory.setItem(i - n3, this.guiItems.getAchievementLock());
            } else {
                List<String> list2 = this.buildLore((Achievement)object, string3, l, bl3, player);
                this.insertAchievement(inventory, i - n3, l, ((Achievement)object).getDisplayName(), string3, bl3, i - n6, list2, ((Achievement)object).getType());
            }
            string = string3;
            string2 = ((Achievement)object).getSubcategory();
        }
        if (this.configBackButtonIsCategoryItem) {
            ItemStack itemStack2 = itemStack.clone();
            object = itemStack2.getItemMeta();
            object.setDisplayName(this.langListBackMessage);
            if (StringUtils.isNotBlank(this.langListBackLore)) {
                object.setLore(Collections.singletonList(this.langListBackLore));
            } else {
                object.setLore(Collections.emptyList());
            }
            itemStack2.setItemMeta((ItemMeta)object);
            inventory.setItem(n5 - 5, itemStack2);
        } else {
            inventory.setItem(n5 - 5, this.guiItems.getBackButton());
        }
        if (n2 > 0) {
            inventory.setItem(n5 - 9, this.guiItems.getPreviousButton());
        }
        if (list.size() > 45 * (n2 + 1)) {
            inventory.setItem(n5 - 1, this.guiItems.getNextButton());
        }
        player.openInventory(inventory);
    }

    private void insertAchievement(Inventory inventory, int n, long l, String string, String string2, boolean bl, int n2, List<String> list, String string3) {
        ItemStack itemStack = string2 != null ? this.guiItems.getAchievementReceived(string3).clone() : (l > 0L ? this.guiItems.getAchievementStarted(string3).clone() : this.guiItems.getAchievementNotStarted(string3).clone());
        String string4 = string2 == null ? this.langListAchievementNotReceived + this.notReceivedStyle(string, bl) : this.langListAchievementReceived + string;
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(this.translateColorCodes(string4));
        itemMeta.setLore(list);
        itemStack.setItemMeta(itemMeta);
        if (this.configNumberedItemsInList) {
            itemStack.setAmount(n2 + 1);
        }
        inventory.setItem(n, itemStack);
    }

    public Map<String, Long> getMultipleStatisticsMapping(MultipleAchievements multipleAchievements, Player player) {
        return this.achievementMap.getSubcategoriesForCategory(multipleAchievements).stream().collect(Collectors.toMap(Function.identity(), string -> this.cacheManager.getAndIncrementStatisticAmount(multipleAchievements, (String)string, player.getUniqueId(), 0)));
    }

    public long getNormalStatistic(NormalAchievements normalAchievements, Player player) {
        return this.cacheManager.getAndIncrementStatisticAmount(normalAchievements, player.getUniqueId(), 0);
    }

    private List<String> getDescriptionsToDisplay(Achievement achievement, boolean bl) {
        if (!bl) {
            return Arrays.asList(StringUtils.splitByWholeSeparator(achievement.getGoal(), "\\n"));
        }
        return Collections.singletonList(achievement.getMessage());
    }

    private int getPageIndex(int n, int n2) {
        if (n <= 0) {
            return 0;
        }
        if (n2 <= 45 * n) {
            return n - 1;
        }
        return n;
    }

    private List<String> buildLore(Achievement achievement, String string2, long l, boolean bl, Player player) {
        List<String> list = this.getDescriptionsToDisplay(achievement, string2 != null);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(NO_SUBCATEGORY);
        if (string2 != null) {
            if (!this.langListDescription.isEmpty()) {
                arrayList.add(this.langListDescription);
            }
            list.forEach(string -> arrayList.add(this.translateColorCodes("&r&f" + string)));
            arrayList.add(NO_SUBCATEGORY);
            if (!this.langListReception.isEmpty()) {
                arrayList.add(this.langListReception);
            }
            arrayList.add(this.translateColorCodes("&r&f" + string2));
        } else {
            if (!this.langListGoal.isEmpty()) {
                arrayList.add(this.langListGoal);
            }
            list.forEach(string -> arrayList.add(this.translateColorCodes(this.notReceivedStyle((String)string, bl))));
            if (!this.configObfuscateNotReceived && l != -1L) {
                boolean bl2;
                arrayList.add(NO_SUBCATEGORY);
                boolean bl3 = bl2 = NormalAchievements.PLAYEDTIME == achievement.getCategory();
                if (!this.langListProgress.isEmpty()) {
                    arrayList.add(this.langListProgress);
                }
                arrayList.add(this.translateColorCodes(this.constructProgressBar(achievement.getThreshold(), l, bl2)));
            }
        }
        List<Reward> list2 = achievement.getRewards();
        if (!list2.isEmpty() && !this.configHideRewardDisplayInList) {
            arrayList.add(NO_SUBCATEGORY);
            if (list2.size() == 1 && !this.langListReward.isEmpty()) {
                arrayList.add(this.langListReward);
            } else if (list2.size() > 1 && !this.langListRewards.isEmpty()) {
                arrayList.add(this.langListRewards);
            }
            String string3 = StringEscapeUtils.unescapeJava(string2 == null ? this.configListColorNotReceived + "\u25cf " + this.configFormatNotReceived : "&r&f\u25cf ");
            for (Reward reward : list2) {
                for (String string4 : reward.getListTexts()) {
                    arrayList.add(StringHelper.replacePlayerPlaceholders(this.translateColorCodes(string3 + string4), player));
                }
            }
        }
        return arrayList;
    }

    private String constructProgressBar(long l, long l2, boolean bl) {
        String string;
        double d;
        if (bl) {
            d = Math.floor((double)l2 / 3600000.0 * 10.0) / 10.0;
            string = TIME_FORMAT.format(d);
        } else {
            d = l2;
            string = Long.toString(l2);
        }
        String string2 = " " + this.configListColorNotReceived + this.configFormatNotReceived + string + "/" + l + " ";
        StringBuilder stringBuilder = new StringBuilder().append(this.configListColorNotReceived).append("[").append(this.configColor);
        int n = this.configEnrichedProgressBars ? (string2.length() - 6) * 3 + 4 : 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        while (++n2 < 90) {
            if (this.configEnrichedProgressBars && !bl2 && n2 >= (90 - n) / 2) {
                stringBuilder.append(string2);
                if (!bl3) {
                    stringBuilder.append(this.configColor);
                }
                bl2 = true;
                bl3 = false;
                n2 = 90 - n2;
                continue;
            }
            if ((double)n2 >= 90.0 * d / (double)l && !bl3) {
                bl3 = true;
                stringBuilder.append(this.configListColorNotReceived);
            }
            stringBuilder.append("|");
        }
        return stringBuilder.append(this.configListColorNotReceived).append("]").toString();
    }

    private String randomiseParts(String string) {
        if (string.isEmpty()) {
            return NO_SUBCATEGORY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : StringUtils.split(string)) {
            stringBuilder.append(RandomStringUtils.randomAlphabetic(string2.length())).append(' ');
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private String notReceivedStyle(String string, boolean bl) {
        if (this.configObfuscateNotReceived || this.configObfuscateProgressiveAchievements && bl) {
            return this.configListColorNotReceived + "&k" + this.randomiseParts(StringHelper.removeFormattingCodes(string));
        }
        return this.configListColorNotReceived + this.configFormatNotReceived + StringHelper.removeFormattingCodes(string);
    }

    private String translateColorCodes(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    private static /* synthetic */ boolean lambda$displayPage$1(List list, String string, int n) {
        return ((Achievement)list.get(n)).getSubcategory().equals(string);
    }

    static {
        TIME_FORMAT.setMaximumFractionDigits(1);
    }
}

