/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.gui;

import com.hm.achievement.category.Category;
import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.gui.AchievementInventoryHolder;
import com.hm.achievement.gui.GUIItems;
import com.hm.achievement.gui.OrderedCategory;
import com.hm.achievement.lifecycle.Reloadable;
import com.hm.achievement.utils.NumberHelper;
import com.hm.apache.commons.lang3.StringUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Singleton
public class MainGUI
implements Reloadable {
    private final YamlConfiguration mainConfig;
    private final YamlConfiguration langConfig;
    private final CacheManager cacheManager;
    private final Set<Category> disabledCategories;
    private final GUIItems guiItems;
    private final AchievementMap achievementMap;
    private boolean configHideNotReceivedCategories;
    private boolean configHideNoPermissionCategories;
    private String langListGUITitle;
    private String langListAchievementsInCategoryPlural;
    private String langListAchievementInCategorySingular;

    @Inject
    public MainGUI(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, CacheManager cacheManager, Set<Category> set, GUIItems gUIItems, AchievementMap achievementMap) {
        this.mainConfig = yamlConfiguration;
        this.langConfig = yamlConfiguration2;
        this.cacheManager = cacheManager;
        this.disabledCategories = set;
        this.guiItems = gUIItems;
        this.achievementMap = achievementMap;
    }

    @Override
    public void extractConfigurationParameters() {
        this.configHideNotReceivedCategories = this.mainConfig.getBoolean("HideNotReceivedCategories");
        this.configHideNoPermissionCategories = this.mainConfig.getBoolean("HideNoPermissionCategories");
        this.langListGUITitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.langConfig.getString("list-gui-title"));
        this.langListAchievementsInCategoryPlural = this.langConfig.getString("list-achievements-in-category-plural");
        this.langListAchievementInCategorySingular = this.langConfig.getString("list-achievements-in-category-singular");
    }

    public void displayMainGUI(Player player) {
        int n = MultipleAchievements.values().length + NormalAchievements.values().length + 1 - this.disabledCategories.size();
        AchievementInventoryHolder achievementInventoryHolder = new AchievementInventoryHolder();
        int n2 = NumberHelper.nextMultipleOf9(n);
        Inventory inventory = Bukkit.createInventory((InventoryHolder)achievementInventoryHolder, (int)n2, (String)this.langListGUITitle);
        achievementInventoryHolder.setInventory(inventory);
        int n3 = 0;
        for (Map.Entry<OrderedCategory, ItemStack> entry : this.guiItems.getOrderedAchievementItems().entrySet()) {
            Category category = entry.getKey().getCategory();
            ItemStack itemStack = entry.getValue();
            if (!this.shouldDisplayCategory(itemStack, player, category)) continue;
            this.displayCategory(itemStack, inventory, player, category, n3);
            ++n3;
        }
        player.openInventory(inventory);
    }

    private boolean shouldDisplayCategory(ItemStack itemStack, Player player, Category category) {
        return itemStack.getItemMeta().getDisplayName().length() > 0 && !this.disabledCategories.contains(category) && (!this.configHideNoPermissionCategories || player.hasPermission(category.toPermName()));
    }

    private void displayCategory(ItemStack itemStack, Inventory inventory, Player player, Category category, int n) {
        long l = this.achievementMap.getForCategory(category).stream().filter(achievement -> this.cacheManager.hasPlayerAchievement(player.getUniqueId(), achievement.getName())).count();
        if (!this.configHideNotReceivedCategories || l > 0L) {
            String string;
            int n2 = this.achievementMap.getForCategory(category).size();
            String string2 = string = n2 > 1 ? this.langListAchievementsInCategoryPlural : this.langListAchievementInCategorySingular;
            if (string.isEmpty()) {
                inventory.setItem(n, itemStack);
            } else {
                ItemStack itemStack2 = itemStack.clone();
                ItemMeta itemMeta = itemStack2.getItemMeta();
                String string3 = StringUtils.replaceOnce(string, "AMOUNT", l + "/" + n2);
                itemMeta.setLore(Arrays.asList(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8" + string3))));
                itemStack2.setItemMeta(itemMeta);
                inventory.setItem(n, itemStack2);
            }
        } else {
            inventory.setItem(n, this.guiItems.getCategoryLock());
        }
    }
}

