/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.lifecycle;

import com.hm.achievement.AdvancedAchievements;
import com.hm.achievement.category.Category;
import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.command.completer.CommandTabCompleter;
import com.hm.achievement.command.executable.ReloadCommand;
import com.hm.achievement.command.executor.PluginCommandExecutor;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.config.ConfigurationParser;
import com.hm.achievement.db.AbstractDatabaseManager;
import com.hm.achievement.db.AsyncCachedRequestsSender;
import com.hm.achievement.lifecycle.Cleaner;
import com.hm.achievement.lifecycle.Reloadable;
import com.hm.achievement.listener.JoinListener;
import com.hm.achievement.listener.ListGUIListener;
import com.hm.achievement.listener.PlayerAdvancedAchievementListener;
import com.hm.achievement.listener.TeleportListener;
import com.hm.achievement.listener.statistics.AbstractListener;
import com.hm.achievement.placeholder.AchievementPlaceholderHook;
import com.hm.achievement.runnable.AchieveDistanceRunnable;
import com.hm.achievement.runnable.AchievePlayTimeRunnable;
import com.hm.apache.commons.lang3.StringUtils;
import com.hm.dagger.Lazy;
import java.util.Set;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitTask;

@Singleton
public class PluginLoader {
    private final AdvancedAchievements advancedAchievements;
    private final Logger logger;
    private final ReloadCommand reloadCommand;
    private final Set<Reloadable> reloadables;
    private final AchievementMap achievementMap;
    private final JoinListener joinListener;
    private final ListGUIListener listGUIListener;
    private final PlayerAdvancedAchievementListener playerAdvancedAchievementListener;
    private final TeleportListener teleportListener;
    private final Lazy<AchievementPlaceholderHook> achievementPlaceholderHook;
    private final AbstractDatabaseManager databaseManager;
    private final AsyncCachedRequestsSender asyncCachedRequestsSender;
    private final PluginCommandExecutor pluginCommandExecutor;
    private final CommandTabCompleter commandTabCompleter;
    private final Set<Category> disabledCategories;
    private final YamlConfiguration mainConfig;
    private final ConfigurationParser configurationParser;
    private final AchieveDistanceRunnable distanceRunnable;
    private final AchievePlayTimeRunnable playTimeRunnable;
    private final Cleaner cleaner;
    private BukkitTask asyncCachedRequestsSenderTask;
    private BukkitTask playedTimeTask;
    private BukkitTask distanceTask;
    private BukkitTask cleanerTask;

    @Inject
    public PluginLoader(AdvancedAchievements advancedAchievements, Logger logger, Set<Reloadable> set, JoinListener joinListener, ListGUIListener listGUIListener, TeleportListener teleportListener, PlayerAdvancedAchievementListener playerAdvancedAchievementListener, Cleaner cleaner, Lazy<AchievementPlaceholderHook> lazy, AbstractDatabaseManager abstractDatabaseManager, AsyncCachedRequestsSender asyncCachedRequestsSender, PluginCommandExecutor pluginCommandExecutor, CommandTabCompleter commandTabCompleter, Set<Category> set2, @Named(value="main") YamlConfiguration yamlConfiguration, ConfigurationParser configurationParser, AchieveDistanceRunnable achieveDistanceRunnable, AchievePlayTimeRunnable achievePlayTimeRunnable, ReloadCommand reloadCommand, AchievementMap achievementMap) {
        this.advancedAchievements = advancedAchievements;
        this.logger = logger;
        this.reloadables = set;
        this.joinListener = joinListener;
        this.listGUIListener = listGUIListener;
        this.teleportListener = teleportListener;
        this.playerAdvancedAchievementListener = playerAdvancedAchievementListener;
        this.cleaner = cleaner;
        this.achievementPlaceholderHook = lazy;
        this.databaseManager = abstractDatabaseManager;
        this.asyncCachedRequestsSender = asyncCachedRequestsSender;
        this.pluginCommandExecutor = pluginCommandExecutor;
        this.commandTabCompleter = commandTabCompleter;
        this.disabledCategories = set2;
        this.mainConfig = yamlConfiguration;
        this.configurationParser = configurationParser;
        this.distanceRunnable = achieveDistanceRunnable;
        this.playTimeRunnable = achievePlayTimeRunnable;
        this.reloadCommand = reloadCommand;
        this.achievementMap = achievementMap;
    }

    public void loadAdvancedAchievements() {
        this.configurationParser.loadAndParseConfiguration();
        this.registerListeners();
        if (!this.databaseManager.isInitialised()) {
            this.databaseManager.initialise();
        }
        this.initialiseCommands();
        this.launchScheduledTasks();
        this.registerPermissions();
        this.reloadCommand.notifyObservers();
        this.linkPlaceholders();
    }

    public void disableAdvancedAchievements() {
        if (this.asyncCachedRequestsSenderTask != null) {
            this.asyncCachedRequestsSenderTask.cancel();
        }
        if (this.cleanerTask != null) {
            this.cleanerTask.cancel();
        }
        if (this.playedTimeTask != null) {
            this.playedTimeTask.cancel();
        }
        if (this.distanceTask != null) {
            this.distanceTask.cancel();
        }
        this.asyncCachedRequestsSender.sendBatchedRequests();
        this.databaseManager.shutdown();
        this.logger.info("Remaining requests sent to the database, plugin successfully disabled.");
    }

    private void registerListeners() {
        this.logger.info("Registering event listeners...");
        HandlerList.unregisterAll((Plugin)this.advancedAchievements);
        PluginManager pluginManager = this.advancedAchievements.getServer().getPluginManager();
        this.reloadables.forEach(reloadable -> {
            AbstractListener abstractListener;
            if (reloadable instanceof AbstractListener && !this.disabledCategories.contains((abstractListener = (AbstractListener)reloadable).getCategory())) {
                pluginManager.registerEvents((Listener)abstractListener, (Plugin)this.advancedAchievements);
            }
        });
        pluginManager.registerEvents((Listener)this.joinListener, (Plugin)this.advancedAchievements);
        pluginManager.registerEvents((Listener)this.listGUIListener, (Plugin)this.advancedAchievements);
        pluginManager.registerEvents((Listener)this.playerAdvancedAchievementListener, (Plugin)this.advancedAchievements);
        pluginManager.registerEvents((Listener)this.teleportListener, (Plugin)this.advancedAchievements);
    }

    private void initialiseCommands() {
        this.logger.info("Setting up command executor and custom tab completers...");
        PluginCommand pluginCommand = Bukkit.getPluginCommand((String)"aach");
        pluginCommand.setTabCompleter((TabCompleter)this.commandTabCompleter);
        pluginCommand.setExecutor((CommandExecutor)this.pluginCommandExecutor);
    }

    private void launchScheduledTasks() {
        long l;
        this.logger.info("Launching scheduled tasks...");
        if (this.asyncCachedRequestsSenderTask == null) {
            l = this.mainConfig.getBoolean("BungeeMode") ? 40L : 1200L;
            this.asyncCachedRequestsSenderTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.advancedAchievements, (Runnable)this.asyncCachedRequestsSender, l, l);
        }
        if (this.cleanerTask == null) {
            l = this.mainConfig.getBoolean("BungeeMode") ? 50L : 20000L;
            this.cleanerTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.advancedAchievements, (Runnable)this.cleaner, l, l);
        }
        if (this.playedTimeTask != null) {
            this.playedTimeTask.cancel();
        }
        if (!this.disabledCategories.contains(NormalAchievements.PLAYEDTIME)) {
            int n = this.mainConfig.getInt("PlaytimeTaskInterval");
            this.playedTimeTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.advancedAchievements, (Runnable)this.playTimeRunnable, (long)n * 10L, (long)n * 20L);
        }
        if (this.distanceTask != null) {
            this.distanceTask.cancel();
        }
        if (!(this.disabledCategories.contains(NormalAchievements.DISTANCEFOOT) && this.disabledCategories.contains(NormalAchievements.DISTANCEPIG) && this.disabledCategories.contains(NormalAchievements.DISTANCEHORSE) && this.disabledCategories.contains(NormalAchievements.DISTANCEMINECART) && this.disabledCategories.contains(NormalAchievements.DISTANCEBOAT) && this.disabledCategories.contains(NormalAchievements.DISTANCEGLIDING) && this.disabledCategories.contains(NormalAchievements.DISTANCELLAMA) && this.disabledCategories.contains(NormalAchievements.DISTANCESNEAKING))) {
            int n = this.mainConfig.getInt("DistanceTaskInterval");
            this.distanceTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.advancedAchievements, (Runnable)this.distanceRunnable, (long)n * 40L, (long)n * 20L);
        }
    }

    private void registerPermissions() {
        Permission permission;
        this.logger.info("Registering permissions...");
        PluginManager pluginManager = Bukkit.getPluginManager();
        for (Object object : MultipleAchievements.values()) {
            permission = new Permission(((MultipleAchievements)object).toPermName(), PermissionDefault.TRUE);
            for (String string : this.achievementMap.getSubcategoriesForCategory((Category)object)) {
                string = StringUtils.deleteWhitespace(string);
                for (String string2 : StringUtils.split(string, '|')) {
                    String string3 = ((MultipleAchievements)object).toChildPermName(string2);
                    if (pluginManager.getPermission(string3) != null) continue;
                    Permission permission2 = new Permission(string3, PermissionDefault.TRUE);
                    permission2.addParent(permission, true);
                    pluginManager.addPermission(permission2);
                }
            }
        }
        Permission permission3 = new Permission("achievement.*", PermissionDefault.OP);
        for (String string : this.achievementMap.getAllNames()) {
            Object object;
            object = "achievement." + string;
            if (pluginManager.getPermission((String)object) != null) continue;
            permission = new Permission((String)object, PermissionDefault.TRUE);
            permission.addParent(permission3, true);
            pluginManager.addPermission(permission);
        }
    }

    private void linkPlaceholders() {
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI") && !this.achievementPlaceholderHook.get().isRegistered()) {
            this.achievementPlaceholderHook.get().register();
        }
    }
}

