/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener;

import com.hm.achievement.AdvancedAchievements;
import com.hm.achievement.advancement.AdvancementManager;
import com.hm.achievement.db.CacheManager;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

@Singleton
public class JoinListener
implements Listener {
    private final AdvancedAchievements advancedAchievements;
    private final CacheManager cacheManager;

    @Inject
    public JoinListener(AdvancedAchievements advancedAchievements, CacheManager cacheManager) {
        this.advancedAchievements = advancedAchievements;
        this.cacheManager = cacheManager;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent playerJoinEvent) {
        this.scheduleReceivedCacheLoad(playerJoinEvent.getPlayer());
        this.scheduleAwardAdvancements(playerJoinEvent.getPlayer());
    }

    private void scheduleReceivedCacheLoad(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.advancedAchievements, () -> this.cacheManager.getPlayerAchievements(player.getUniqueId()));
    }

    private void scheduleAwardAdvancements(Player player) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.advancedAchievements, () -> {
            if (!player.isOnline()) {
                return;
            }
            Advancement advancement = Bukkit.getAdvancement((NamespacedKey)new NamespacedKey((Plugin)this.advancedAchievements, "advanced_achievements_parent"));
            if (advancement != null) {
                AdvancementProgress advancementProgress = player.getAdvancementProgress(advancement);
                if (!advancementProgress.isDone()) {
                    advancementProgress.awardCriteria("aach_handled");
                }
                for (String string : this.cacheManager.getPlayerAchievements(player.getUniqueId())) {
                    advancement = Bukkit.getAdvancement((NamespacedKey)new NamespacedKey((Plugin)this.advancedAchievements, AdvancementManager.getKey(string)));
                    if (advancement == null || (advancementProgress = player.getAdvancementProgress(advancement)).isDone()) continue;
                    advancementProgress.awardCriteria("aach_handled");
                }
            }
        }, 200L);
    }
}

