/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener;

import com.hm.achievement.AdvancedAchievements;
import com.hm.achievement.advancement.AdvancementManager;
import com.hm.achievement.command.executable.ToggleCommand;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.config.RewardParser;
import com.hm.achievement.db.AbstractDatabaseManager;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.domain.Achievement;
import com.hm.achievement.domain.Reward;
import com.hm.achievement.lifecycle.Reloadable;
import com.hm.achievement.utils.ColorHelper;
import com.hm.achievement.utils.FancyMessageSender;
import com.hm.achievement.utils.PlayerAdvancedAchievementEvent;
import com.hm.achievement.utils.StringHelper;
import com.hm.apache.commons.lang3.EnumUtils;
import com.hm.apache.commons.lang3.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.advancement.Advancement;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@Singleton
public class PlayerAdvancedAchievementListener
implements Listener,
Reloadable {
    private static final Random RANDOM = new Random();
    private static final String ADVANCED_ACHIEVEMENTS_FIREWORK = "advanced_achievements_firework";
    private static final Map<ChatColor, ChatColor> FIREWORK_COLOR_MIX = new HashMap<ChatColor, ChatColor>();
    private final YamlConfiguration mainConfig;
    private final YamlConfiguration langConfig;
    private final Logger logger;
    private final StringBuilder pluginHeader;
    private final CacheManager cacheManager;
    private final AdvancedAchievements advancedAchievements;
    private final RewardParser rewardParser;
    private final AchievementMap achievementMap;
    private final AbstractDatabaseManager databaseManager;
    private final ToggleCommand toggleCommand;
    private final FancyMessageSender fancyMessageSender;
    private String configFireworkStyle;
    private boolean configFirework;
    private Color configColor;
    private Color mixColor;
    private BarColor barColor;
    private boolean configSimplifiedReception;
    private boolean configTitleScreen;
    private boolean configNotifyOtherPlayers;
    private boolean configActionBarNotify;
    private boolean configHoverableReceiverChatText;
    private boolean configReceiverChatMessages;
    private boolean configBossBarProgress;
    private String langAchievementReceived;
    private String langAchievementNew;
    private String langAllAchievementsReceived;
    private String langBossBarProgress;

    @Inject
    public PlayerAdvancedAchievementListener(@Named(value="main") YamlConfiguration yamlConfiguration, @Named(value="lang") YamlConfiguration yamlConfiguration2, Logger logger, StringBuilder stringBuilder, CacheManager cacheManager, AdvancedAchievements advancedAchievements, RewardParser rewardParser, AchievementMap achievementMap, AbstractDatabaseManager abstractDatabaseManager, ToggleCommand toggleCommand, FancyMessageSender fancyMessageSender) {
        this.mainConfig = yamlConfiguration;
        this.langConfig = yamlConfiguration2;
        this.logger = logger;
        this.pluginHeader = stringBuilder;
        this.cacheManager = cacheManager;
        this.advancedAchievements = advancedAchievements;
        this.rewardParser = rewardParser;
        this.achievementMap = achievementMap;
        this.databaseManager = abstractDatabaseManager;
        this.toggleCommand = toggleCommand;
        this.fancyMessageSender = fancyMessageSender;
    }

    @Override
    public void extractConfigurationParameters() {
        this.configFireworkStyle = this.mainConfig.getString("FireworkStyle").toUpperCase();
        if (!"RANDOM".equals(this.configFireworkStyle) && !EnumUtils.isValidEnum(FireworkEffect.Type.class, this.configFireworkStyle)) {
            this.configFireworkStyle = FireworkEffect.Type.BALL_LARGE.name();
            this.logger.warning("Failed to load FireworkStyle, using ball_large instead. Please use one of the following: ball_large, ball, burst, creeper, star or random.");
        }
        this.configFirework = this.mainConfig.getBoolean("Firework");
        this.configSimplifiedReception = this.mainConfig.getBoolean("SimplifiedReception");
        this.configTitleScreen = this.mainConfig.getBoolean("TitleScreen");
        this.configNotifyOtherPlayers = this.mainConfig.getBoolean("NotifyOtherPlayers");
        this.configActionBarNotify = this.mainConfig.getBoolean("ActionBarNotify");
        this.configHoverableReceiverChatText = this.mainConfig.getBoolean("HoverableReceiverChatText");
        this.configBossBarProgress = this.mainConfig.getBoolean("BossBarProgress");
        this.configReceiverChatMessages = this.mainConfig.getBoolean("ReceiverChatMessages");
        ChatColor chatColor = ChatColor.getByChar((String)this.mainConfig.getString("Color"));
        this.configColor = ColorHelper.convertChatColorToColor(chatColor);
        this.mixColor = Color.WHITE.mixColors(new Color[]{ColorHelper.convertChatColorToColor(FIREWORK_COLOR_MIX.get(chatColor))});
        this.barColor = ColorHelper.convertChatColorToBarColor(chatColor);
        this.langAchievementReceived = this.langConfig.getString("achievement-received") + " " + ChatColor.WHITE;
        this.langAchievementNew = this.pluginHeader + this.langConfig.getString("achievement-new") + " " + ChatColor.WHITE;
        this.langAllAchievementsReceived = this.pluginHeader + this.langConfig.getString("all-achievements-received");
        this.langBossBarProgress = this.langConfig.getString("boss-bar-progress");
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        entityDamageByEntityEvent.setCancelled(entityDamageByEntityEvent.getEntity().hasMetadata(ADVANCED_ACHIEVEMENTS_FIREWORK));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerAdvancedAchievementReception(PlayerAdvancedAchievementEvent playerAdvancedAchievementEvent) {
        Achievement achievement = playerAdvancedAchievementEvent.getAchievement();
        Player player = playerAdvancedAchievementEvent.getPlayer();
        if (!this.cacheManager.hasPlayerAchievement(player.getUniqueId(), achievement.getName())) {
            this.cacheManager.registerNewlyReceivedAchievement(player.getUniqueId(), achievement.getName());
            Advancement advancement = Bukkit.getAdvancement((NamespacedKey)new NamespacedKey((Plugin)this.advancedAchievements, AdvancementManager.getKey(achievement.getName())));
            if (advancement != null) {
                player.getAdvancementProgress(advancement).awardCriteria("aach_handled");
            }
        }
        this.databaseManager.registerAchievement(player.getUniqueId(), achievement.getName(), System.currentTimeMillis());
        achievement.getRewards().forEach(reward -> reward.getRewarder().accept(player));
        this.displayAchievement(player, achievement);
        if (this.cacheManager.getPlayerAchievements(player.getUniqueId()).size() == this.achievementMap.getAll().size()) {
            this.handleAllAchievementsReceived(player);
        }
    }

    private void displayAchievement(Player player, Achievement achievement) {
        this.logger.info("Player " + player.getName() + " received the achievement: " + achievement.getDisplayName());
        String string = ChatColor.translateAlternateColorCodes((char)'&', (String)achievement.getDisplayName());
        String string2 = ChatColor.translateAlternateColorCodes((char)'&', (String)achievement.getMessage());
        if (this.configReceiverChatMessages || player.hasPermission("achievement.config.receiver.chat.messages")) {
            this.displayReceiverMessages(player, string, string2, achievement.getRewards());
        }
        for (Player player2 : this.advancedAchievements.getServer().getOnlinePlayers()) {
            if (player2.getName().equals(player.getName()) || !(this.configNotifyOtherPlayers ^ this.toggleCommand.isPlayerToggled(player2, achievement.getType()))) continue;
            this.displayNotification(player, string, player2);
        }
        if (this.configFirework) {
            this.displayFirework(player);
        } else if (this.configSimplifiedReception) {
            this.displaySimplifiedReception(player);
        }
        if (this.configTitleScreen || player.hasPermission("achievement.config.title.screen")) {
            player.sendTitle(string, string2, 10, 70, 20);
        }
        if (this.configBossBarProgress) {
            int n = this.cacheManager.getPlayerAchievements(player.getUniqueId()).size();
            int n2 = this.achievementMap.getAll().size();
            double d = (double)n / (double)n2;
            String string3 = StringUtils.replaceOnce(this.langBossBarProgress, "AMOUNT", n + "/" + n2);
            BossBar bossBar = Bukkit.getServer().createBossBar(string3, this.barColor, BarStyle.SOLID, new BarFlag[0]);
            bossBar.setProgress(d);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.advancedAchievements, () -> bossBar.addPlayer(player), 110L);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.advancedAchievements, () -> bossBar.removePlayer(player), 240L);
        }
    }

    private void displayReceiverMessages(Player player, String string2, String string3, List<Reward> list) {
        String string4;
        List<String> list2 = list.stream().map(Reward::getChatTexts).flatMap(Collection::stream).map(string -> StringHelper.replacePlayerPlaceholders(string, player)).collect(Collectors.toList());
        String string5 = string4 = this.langAchievementNew.contains("ACH") ? StringUtils.replaceOnce(this.langAchievementNew, "ACH", string2) : this.langAchievementNew + string2;
        if (this.configHoverableReceiverChatText) {
            StringBuilder stringBuilder = new StringBuilder(string3 + "\n");
            list2.forEach(string -> stringBuilder.append(ChatColor.translateAlternateColorCodes((char)'&', (String)string)).append("\n"));
            this.fancyMessageSender.sendHoverableMessage(player, string4, stringBuilder.substring(0, stringBuilder.length() - 1), "white");
            return;
        }
        player.sendMessage(string4);
        player.sendMessage(this.pluginHeader.toString() + ChatColor.WHITE + string3);
        list2.forEach(string -> player.sendMessage(this.pluginHeader + ChatColor.translateAlternateColorCodes((char)'&', (String)string)));
    }

    private void displayNotification(Player player, String string, Player player2) {
        String string2;
        String string3 = string2 = this.langAchievementReceived.contains("ACH") ? StringUtils.replaceEach(this.langAchievementReceived, new String[]{"PLAYER", "ACH"}, new String[]{player.getName(), string}) : StringUtils.replaceOnce(this.langAchievementReceived, "PLAYER", player.getName()) + string;
        if (this.configActionBarNotify) {
            player2.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)("&o" + string2)));
        } else {
            player2.sendMessage(this.pluginHeader + string2);
        }
    }

    private void displayFirework(Player player) {
        Location location = player.getLocation().subtract(0.0, 1.0, 0.0);
        Firework firework = (Firework)player.getWorld().spawn(location, Firework.class);
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        FireworkEffect fireworkEffect = FireworkEffect.builder().withColor(this.configColor).withFade(this.mixColor).with(this.getFireworkType()).build();
        fireworkMeta.addEffects(new FireworkEffect[]{fireworkEffect});
        firework.setFireworkMeta(fireworkMeta);
        firework.setMetadata(ADVANCED_ACHIEVEMENTS_FIREWORK, (MetadataValue)new FixedMetadataValue((Plugin)this.advancedAchievements, (Object)true));
        firework.setVelocity(location.getDirection().multiply(0));
    }

    private FireworkEffect.Type getFireworkType() {
        if ("RANDOM".equals(this.configFireworkStyle)) {
            FireworkEffect.Type[] typeArray = FireworkEffect.Type.values();
            return typeArray[RANDOM.nextInt(typeArray.length)];
        }
        return FireworkEffect.Type.valueOf((String)this.configFireworkStyle);
    }

    private void displaySimplifiedReception(Player player) {
        player.playSound(player.getLocation(), Sound.valueOf((String)"ENTITY_PLAYER_LEVELUP"), 1.0f, 0.7f);
        player.spawnParticle(Particle.FIREWORKS_SPARK, player.getLocation(), 500, 0.0, 3.0, 0.0, (double)0.1f);
    }

    private void handleAllAchievementsReceived(Player player) {
        List<Reward> list = this.rewardParser.parseRewards("AllAchievementsReceivedRewards");
        list.forEach(reward -> reward.getRewarder().accept(player));
        player.sendMessage(this.langAllAchievementsReceived);
        list.stream().map(Reward::getChatTexts).flatMap(Collection::stream).map(string -> StringHelper.replacePlayerPlaceholders(string, player)).forEach(string -> player.sendMessage(this.pluginHeader + ChatColor.translateAlternateColorCodes((char)'&', (String)string)));
    }

    static {
        FIREWORK_COLOR_MIX.put(ChatColor.AQUA, ChatColor.DARK_AQUA);
        FIREWORK_COLOR_MIX.put(ChatColor.BLACK, ChatColor.GRAY);
        FIREWORK_COLOR_MIX.put(ChatColor.BLUE, ChatColor.DARK_BLUE);
        FIREWORK_COLOR_MIX.put(ChatColor.GRAY, ChatColor.DARK_GRAY);
        FIREWORK_COLOR_MIX.put(ChatColor.DARK_AQUA, ChatColor.AQUA);
        FIREWORK_COLOR_MIX.put(ChatColor.DARK_BLUE, ChatColor.BLUE);
        FIREWORK_COLOR_MIX.put(ChatColor.DARK_GRAY, ChatColor.GRAY);
        FIREWORK_COLOR_MIX.put(ChatColor.DARK_GREEN, ChatColor.GREEN);
        FIREWORK_COLOR_MIX.put(ChatColor.DARK_PURPLE, ChatColor.LIGHT_PURPLE);
        FIREWORK_COLOR_MIX.put(ChatColor.DARK_RED, ChatColor.RED);
        FIREWORK_COLOR_MIX.put(ChatColor.GOLD, ChatColor.YELLOW);
        FIREWORK_COLOR_MIX.put(ChatColor.GREEN, ChatColor.DARK_GREEN);
        FIREWORK_COLOR_MIX.put(ChatColor.LIGHT_PURPLE, ChatColor.DARK_PURPLE);
        FIREWORK_COLOR_MIX.put(ChatColor.RED, ChatColor.DARK_RED);
        FIREWORK_COLOR_MIX.put(ChatColor.WHITE, ChatColor.GRAY);
        FIREWORK_COLOR_MIX.put(ChatColor.YELLOW, ChatColor.GOLD);
    }
}

