/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener.statistics;

import com.hm.achievement.AdvancedAchievements;
import com.hm.achievement.category.Category;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.domain.Achievement;
import com.hm.achievement.lifecycle.Cleanable;
import com.hm.achievement.listener.statistics.AbstractListener;
import com.hm.apache.commons.lang3.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AbstractRateLimitedListener
extends AbstractListener
implements Cleanable {
    private final Map<Integer, Map<UUID, Long>> slotsToPlayersLastActionTimes = new HashMap<Integer, Map<UUID, Long>>();
    private final AdvancedAchievements advancedAchievements;
    private final YamlConfiguration langConfig;
    private int categoryCooldown;
    private long hardestCategoryThreshold;
    private boolean configCooldownActionBar;
    private String langStatisticCooldown;

    AbstractRateLimitedListener(Category category, YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager, AdvancedAchievements advancedAchievements, YamlConfiguration yamlConfiguration2) {
        super(category, yamlConfiguration, achievementMap, cacheManager);
        this.advancedAchievements = advancedAchievements;
        this.langConfig = yamlConfiguration2;
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        List<Achievement> list = this.achievementMap.getForCategory(this.category);
        this.hardestCategoryThreshold = list.isEmpty() ? Long.MAX_VALUE : list.get(list.size() - 1).getThreshold();
        this.categoryCooldown = this.mainConfig.getInt("StatisticCooldown." + this.category) * 1000;
        this.configCooldownActionBar = this.mainConfig.getBoolean("CooldownActionBar");
        this.langStatisticCooldown = this.langConfig.getString("statistic-cooldown");
    }

    @Override
    public void cleanPlayerData() {
        long l = System.currentTimeMillis();
        this.slotsToPlayersLastActionTimes.values().forEach(map -> map.values().removeIf(l2 -> l > l2 + (long)this.categoryCooldown));
    }

    void updateStatisticAndAwardAchievementsIfAvailable(Player player, int n, int n2) {
        if (!this.isInCooldownPeriod(player, n2)) {
            super.updateStatisticAndAwardAchievementsIfAvailable(player, n);
        }
    }

    @Override
    void updateStatisticAndAwardAchievementsIfAvailable(Player player, int n) {
        if (!this.isInCooldownPeriod(player, 0)) {
            super.updateStatisticAndAwardAchievementsIfAvailable(player, n);
        }
    }

    private boolean isInCooldownPeriod(Player player, int n) {
        UUID uUID = player.getUniqueId();
        long l = this.cacheManager.getAndIncrementStatisticAmount((NormalAchievements)this.category, uUID, 0);
        if (l >= this.hardestCategoryThreshold) {
            return false;
        }
        Map map = this.slotsToPlayersLastActionTimes.computeIfAbsent(n, HashMap::new);
        long l2 = System.currentTimeMillis();
        long l3 = map.getOrDefault(uUID, 0L) + (long)this.categoryCooldown - l2;
        if (l3 > 0L) {
            if (this.configCooldownActionBar) {
                if (this.category == NormalAchievements.MUSICDISCS) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.advancedAchievements, () -> this.displayActionBarMessage(player, l3), 20L);
                } else {
                    this.displayActionBarMessage(player, l3);
                }
            }
            return true;
        }
        map.put(uUID, l2);
        return false;
    }

    private void displayActionBarMessage(Player player, long l) {
        String string = String.format("%.1f", (double)l / 1000.0);
        String string2 = "&o" + StringUtils.replaceOnce(this.langStatisticCooldown, "TIME", string);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)string2));
    }
}

