/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener.statistics;

import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.listener.statistics.AbstractListener;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityBreedEvent;

@Singleton
public class BreedingListener
extends AbstractListener {
    @Inject
    public BreedingListener(@Named(value="main") YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager) {
        super(MultipleAchievements.BREEDING, yamlConfiguration, achievementMap, cacheManager);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityBreed(EntityBreedEvent entityBreedEvent) {
        if (!(entityBreedEvent.getBreeder() instanceof Player)) {
            return;
        }
        String string = entityBreedEvent.getMother().getType().name().toLowerCase();
        if (!entityBreedEvent.getBreeder().hasPermission(this.category.toChildPermName(string))) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        this.addMatchingSubcategories(hashSet, string);
        this.updateStatisticAndAwardAchievementsIfAvailable((Player)entityBreedEvent.getBreeder(), hashSet, 1);
    }
}

