/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener.statistics;

import com.hm.achievement.AdvancedAchievements;
import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.AbstractDatabaseManager;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.db.data.ConnectionInformation;
import com.hm.achievement.listener.statistics.AbstractListener;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

@Singleton
public class ConnectionsListener
extends AbstractListener {
    private final AdvancedAchievements advancedAchievements;
    private final AbstractDatabaseManager databaseManager;

    @Inject
    public ConnectionsListener(@Named(value="main") YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager, AdvancedAchievements advancedAchievements, AbstractDatabaseManager abstractDatabaseManager) {
        super(NormalAchievements.CONNECTIONS, yamlConfiguration, achievementMap, cacheManager);
        this.advancedAchievements = advancedAchievements;
        this.databaseManager = abstractDatabaseManager;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent playerJoinEvent) {
        this.scheduleAwardConnection(playerJoinEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldChanged(PlayerChangedWorldEvent playerChangedWorldEvent) {
        this.scheduleAwardConnection(playerChangedWorldEvent.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onGameModeChange(PlayerGameModeChangeEvent playerGameModeChangeEvent) {
        this.scheduleAwardConnection(playerGameModeChangeEvent.getPlayer());
    }

    private void scheduleAwardConnection(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.advancedAchievements, () -> {
            ConnectionInformation connectionInformation = this.databaseManager.getConnectionInformation(player.getUniqueId());
            if (!ConnectionInformation.today().equals(connectionInformation.getDate())) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.advancedAchievements, () -> {
                    if (player.isOnline() && this.shouldIncreaseBeTakenIntoAccount(player, this.category)) {
                        long l = connectionInformation.getCount() + 1L;
                        this.databaseManager.updateConnectionInformation(player.getUniqueId(), l);
                        this.checkThresholdsAndAchievements(player, this.category, l);
                    }
                }, 100L);
            }
        });
    }
}

