/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener.statistics;

import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.listener.statistics.AbstractListener;
import com.hm.achievement.utils.MaterialHelper;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerItemConsumeEvent;

@Singleton
public class ConsumedPotionsListener
extends AbstractListener {
    private final MaterialHelper materialHelper;

    @Inject
    public ConsumedPotionsListener(@Named(value="main") YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager, MaterialHelper materialHelper) {
        super(NormalAchievements.CONSUMEDPOTIONS, yamlConfiguration, achievementMap, cacheManager);
        this.materialHelper = materialHelper;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerItemConsume(PlayerItemConsumeEvent playerItemConsumeEvent) {
        if (this.materialHelper.isAnyPotionButWater(playerItemConsumeEvent.getItem())) {
            this.updateStatisticAndAwardAchievementsIfAvailable(playerItemConsumeEvent.getPlayer(), 1);
        }
    }
}

