/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener.statistics;

import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.listener.statistics.AbstractListener;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

@Singleton
public class FireworksListener
extends AbstractListener {
    private Set<String> forbiddenFireworkBlocks;
    private Set<String> forbiddenFireworkBlocksWhenNotSneaking;
    private final int serverVersion;

    @Inject
    public FireworksListener(@Named(value="main") YamlConfiguration yamlConfiguration, int n, AchievementMap achievementMap, CacheManager cacheManager) {
        super(NormalAchievements.FIREWORKS, yamlConfiguration, achievementMap, cacheManager);
        this.serverVersion = n;
    }

    @Override
    public void extractConfigurationParameters() {
        super.extractConfigurationParameters();
        this.forbiddenFireworkBlocks = new HashSet<String>();
        for (String string : this.mainConfig.getStringList("ForbiddenFireworkBlocks")) {
            this.forbiddenFireworkBlocks.add(string.toUpperCase());
        }
        this.forbiddenFireworkBlocksWhenNotSneaking = new HashSet<String>();
        for (String string : this.mainConfig.getStringList("ForbiddenFireworkBlocksWhenNotSneaking")) {
            this.forbiddenFireworkBlocksWhenNotSneaking.add(string.toUpperCase());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerInteract(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.useItemInHand() == Event.Result.DENY || !playerInteractEvent.hasItem()) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        if (playerInteractEvent.getMaterial() != Material.FIREWORK_ROCKET || !this.canAccommodateFireworkLaunch(playerInteractEvent.getClickedBlock(), player, playerInteractEvent.getAction())) {
            return;
        }
        this.updateStatisticAndAwardAchievementsIfAvailable(player, 1);
    }

    private boolean canAccommodateFireworkLaunch(Block block, Player player, Action action) {
        if (player.isGliding() && action == Action.RIGHT_CLICK_AIR) {
            return true;
        }
        if (action != Action.RIGHT_CLICK_BLOCK) {
            return false;
        }
        if (!player.isSneaking()) {
            if (this.serverVersion >= 14 && block.getType() == Material.SWEET_BERRY_BUSH) {
                return ((Ageable)block.getBlockData()).getAge() <= 1;
            }
            if (this.forbiddenFireworkBlocksWhenNotSneaking.contains(block.getType().name())) {
                return false;
            }
        }
        return !this.forbiddenFireworkBlocks.contains(block.getType().name());
    }
}

