/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener.statistics;

import com.gamingmesh.jobs.api.JobsLevelUpEvent;
import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.listener.statistics.AbstractListener;
import java.util.Collections;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;

@Singleton
public class JobsRebornListener
extends AbstractListener {
    @Inject
    public JobsRebornListener(@Named(value="main") YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager) {
        super(MultipleAchievements.JOBSREBORN, yamlConfiguration, achievementMap, cacheManager);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onJob(JobsLevelUpEvent jobsLevelUpEvent) {
        Player player = jobsLevelUpEvent.getPlayer().getPlayer();
        if (player == null) {
            return;
        }
        String string2 = jobsLevelUpEvent.getJob().getJobFullName().toLowerCase();
        if (!player.hasPermission(this.category.toChildPermName(string2))) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        this.addMatchingSubcategories(hashSet, string2);
        hashSet.forEach(string -> {
            int n = (int)this.cacheManager.getAndIncrementStatisticAmount(MultipleAchievements.JOBSREBORN, (String)string, player.getUniqueId(), 0);
            int n2 = jobsLevelUpEvent.getLevel() - n;
            if (n2 > 0) {
                this.updateStatisticAndAwardAchievementsIfAvailable(player, Collections.singleton(string), n2);
            }
        });
    }
}

