/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener.statistics;

import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.listener.statistics.AbstractListener;
import com.hm.apache.commons.lang3.StringUtils;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDeathEvent;

@Singleton
public class KillsListener
extends AbstractListener {
    @Inject
    public KillsListener(@Named(value="main") YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager) {
        super(MultipleAchievements.KILLS, yamlConfiguration, achievementMap, cacheManager);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent entityDeathEvent) {
        String string;
        Player player = entityDeathEvent.getEntity().getKiller();
        if (player == null) {
            return;
        }
        LivingEntity livingEntity = entityDeathEvent.getEntity();
        String string2 = livingEntity instanceof Creeper && ((Creeper)livingEntity).isPowered() ? "poweredcreeper" : livingEntity.getType().name().toLowerCase();
        HashSet<String> hashSet = new HashSet<String>();
        if (player.hasPermission(this.category.toChildPermName(string2))) {
            this.addMatchingSubcategories(hashSet, string2);
        }
        if (livingEntity.getCustomName() != null && player.hasPermission(this.category.toChildPermName(StringUtils.deleteWhitespace(livingEntity.getCustomName())))) {
            this.addMatchingSubcategories(hashSet, livingEntity.getCustomName());
        }
        if (livingEntity instanceof Player && player.hasPermission(this.category.toChildPermName(string = "specificplayer-" + livingEntity.getUniqueId()))) {
            this.addMatchingSubcategories(hashSet, string);
        }
        this.updateStatisticAndAwardAchievementsIfAvailable(player, hashSet, 1);
    }
}

