/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener.statistics;

import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.listener.statistics.AbstractListener;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerLevelChangeEvent;

@Singleton
public class LevelsListener
extends AbstractListener {
    @Inject
    public LevelsListener(@Named(value="main") YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager) {
        super(NormalAchievements.LEVELS, yamlConfiguration, achievementMap, cacheManager);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerExpChange(PlayerLevelChangeEvent playerLevelChangeEvent) {
        Player player = playerLevelChangeEvent.getPlayer();
        int n = (int)this.cacheManager.getAndIncrementStatisticAmount(NormalAchievements.LEVELS, player.getUniqueId(), 0);
        if (playerLevelChangeEvent.getNewLevel() <= n) {
            return;
        }
        this.updateStatisticAndAwardAchievementsIfAvailable(player, playerLevelChangeEvent.getNewLevel() - n);
    }
}

