/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener.statistics;

import com.hm.achievement.category.MultipleAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.listener.statistics.AbstractListener;
import com.hm.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

@Singleton
public class PlayerCommandsListener
extends AbstractListener {
    @Inject
    public PlayerCommandsListener(@Named(value="main") YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager) {
        super(MultipleAchievements.PLAYERCOMMANDS, yamlConfiguration, achievementMap, cacheManager);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerCommand(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        Player player = playerCommandPreprocessEvent.getPlayer();
        List<String> list = this.getEquivalentCommands(playerCommandPreprocessEvent.getMessage());
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.subcategories) {
            for (String string2 : StringUtils.split(string, '|')) {
                if (!player.hasPermission(this.category.toChildPermName(StringUtils.deleteWhitespace(string2)))) continue;
                for (String string3 : list) {
                    if (!string3.startsWith(string2)) continue;
                    hashSet.add(string);
                }
            }
        }
        this.updateStatisticAndAwardAchievementsIfAvailable(player, hashSet, 1);
    }

    private List<String> getEquivalentCommands(String string) {
        String string2;
        String string3;
        int n = string.indexOf(32);
        if (n >= 0) {
            string3 = string.substring(1, n);
            string2 = string.substring(n).toLowerCase();
        } else {
            string3 = string.substring(1);
            string2 = "";
        }
        PluginCommand pluginCommand = Bukkit.getPluginCommand((String)string3);
        if (pluginCommand == null || pluginCommand.getAliases() == null) {
            return Arrays.asList(string3.toLowerCase() + string2);
        }
        ArrayList<String> arrayList = new ArrayList<String>(pluginCommand.getAliases().size() + 1);
        arrayList.add(pluginCommand.getName().toLowerCase() + string2);
        for (String string4 : pluginCommand.getAliases()) {
            arrayList.add(string4.toLowerCase() + string2);
        }
        return arrayList;
    }
}

