/*
 * Decompiled with CFR 0.152.
 */
package com.hm.achievement.listener.statistics;

import com.hm.achievement.category.NormalAchievements;
import com.hm.achievement.config.AchievementMap;
import com.hm.achievement.db.CacheManager;
import com.hm.achievement.listener.statistics.AbstractListener;
import com.hm.achievement.utils.InventoryHelper;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;

@Singleton
public class SmeltingListener
extends AbstractListener {
    @Inject
    public SmeltingListener(@Named(value="main") YamlConfiguration yamlConfiguration, AchievementMap achievementMap, CacheManager cacheManager) {
        super(NormalAchievements.SMELTING, yamlConfiguration, achievementMap, cacheManager);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (inventoryClickEvent.getRawSlot() != 2 || inventoryClickEvent.getInventory().getType() != InventoryType.FURNACE || itemStack == null || itemStack.getType() == Material.AIR || inventoryClickEvent.getAction() == InventoryAction.NOTHING || inventoryClickEvent.getClick() == ClickType.NUMBER_KEY && inventoryClickEvent.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD) {
            return;
        }
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        int n = itemStack.getAmount();
        if (inventoryClickEvent.isShiftClick() && (n = Math.min(n, InventoryHelper.getAvailableSpace(player, itemStack))) == 0) {
            return;
        }
        this.updateStatisticAndAwardAchievementsIfAvailable(player, n);
    }
}

